/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.timeseries;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.parameters.DataType;
import com.crazzyghost.alphavantage.parameters.Interval;
import com.crazzyghost.alphavantage.parameters.OutputSize;
import com.crazzyghost.alphavantage.parser.Parser;
import com.crazzyghost.alphavantage.timeseries.request.DailyRequest;
import com.crazzyghost.alphavantage.timeseries.request.IntraDayRequest;
import com.crazzyghost.alphavantage.timeseries.request.MonthlyRequest;
import com.crazzyghost.alphavantage.timeseries.request.QuoteRequest;
import com.crazzyghost.alphavantage.timeseries.request.TimeSeriesRequest;
import com.crazzyghost.alphavantage.timeseries.request.WeeklyRequest;
import com.crazzyghost.alphavantage.timeseries.response.QuoteResponse;
import com.crazzyghost.alphavantage.timeseries.response.TimeSeriesResponse;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class TimeSeries
implements Fetcher {
    private final Config config;
    private TimeSeriesRequest.Builder<?> builder;
    private boolean adjusted = false;
    private Fetcher.SuccessCallback<?> successCallback;
    private Fetcher.FailureCallback failureCallback;

    public TimeSeries(Config config) {
        this.config = config;
    }

    public MonthlyRequestProxy monthly() {
        this.adjusted = false;
        return new MonthlyRequestProxy();
    }

    public WeeklyRequestProxy weekly() {
        this.adjusted = false;
        return new WeeklyRequestProxy();
    }

    public DailyRequestProxy daily() {
        this.adjusted = false;
        return new DailyRequestProxy();
    }

    public IntraDayRequestProxy intraday() {
        return new IntraDayRequestProxy();
    }

    public GlobalQuoteRequestProxy quote() {
        return new GlobalQuoteRequestProxy();
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (TimeSeries.this.failureCallback != null) {
                    TimeSeries.this.failureCallback.onFailure(new AlphaVantageException(e.getMessage()));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        TimeSeries.this.parseResponse(Parser.parseJSON(body.string()));
                    }
                } else if (TimeSeries.this.failureCallback != null) {
                    TimeSeries.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }
        });
    }

    private void fetchSync(Fetcher.SuccessCallback<?> successCallback) throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = successCallback;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            this.parseResponse(Parser.parseJSON(response.body().string()));
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    private void parseTimeSeriesResponse(Map<String, Object> data) {
        TimeSeriesResponse response = TimeSeriesResponse.of(data, this.adjusted);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseGlobalQuoteResponse(Map<String, Object> data) {
        QuoteResponse response = QuoteResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseResponse(Map<String, Object> data) {
        switch (this.builder.function) {
            case TIME_SERIES_DAILY: 
            case TIME_SERIES_DAILY_ADJUSTED: 
            case TIME_SERIES_MONTHLY: 
            case TIME_SERIES_MONTHLY_ADJUSTED: 
            case TIME_SERIES_WEEKLY: 
            case TIME_SERIES_WEEKLY_ADJUSTED: 
            case TIME_SERIES_INTRADAY: {
                this.parseTimeSeriesResponse(data);
                break;
            }
            case GLOBAL_QUOTE: {
                this.parseGlobalQuoteResponse(data);
            }
        }
    }

    public class GlobalQuoteRequestProxy
    extends RequestProxy<GlobalQuoteRequestProxy, QuoteResponse> {
        GlobalQuoteRequestProxy() {
            this.builder = new QuoteRequest.Builder();
        }
    }

    public class MonthlyRequestProxy
    extends RequestProxy<MonthlyRequestProxy, TimeSeriesResponse> {
        MonthlyRequestProxy() {
            this.builder = new MonthlyRequest.Builder();
        }

        public MonthlyRequestProxy adjusted() {
            TimeSeries.this.adjusted = true;
            ((MonthlyRequest.Builder)this.builder).adjusted();
            return this;
        }
    }

    public class WeeklyRequestProxy
    extends RequestProxy<WeeklyRequestProxy, TimeSeriesResponse> {
        WeeklyRequestProxy() {
            this.builder = new WeeklyRequest.Builder();
        }

        public WeeklyRequestProxy adjusted() {
            TimeSeries.this.adjusted = true;
            ((WeeklyRequest.Builder)this.builder).adjusted();
            return this;
        }
    }

    public class IntraDayRequestProxy
    extends RequestProxy<IntraDayRequestProxy, TimeSeriesResponse> {
        IntraDayRequestProxy() {
            this.builder = new IntraDayRequest.Builder();
        }

        public IntraDayRequestProxy outputSize(OutputSize size) {
            ((IntraDayRequest.Builder)this.builder).outputSize(size);
            return this;
        }

        public IntraDayRequestProxy interval(Interval interval) {
            ((IntraDayRequest.Builder)this.builder).interval(interval);
            return this;
        }
    }

    public class DailyRequestProxy
    extends RequestProxy<DailyRequestProxy, TimeSeriesResponse> {
        DailyRequestProxy() {
            this.builder = new DailyRequest.Builder();
        }

        public DailyRequestProxy outputSize(OutputSize size) {
            ((DailyRequest.Builder)this.builder).outputSize(size);
            return this;
        }

        public DailyRequestProxy adjusted() {
            TimeSeries.this.adjusted = true;
            ((DailyRequest.Builder)this.builder).adjusted();
            return this;
        }
    }

    public abstract class RequestProxy<T extends RequestProxy<?, U>, U> {
        protected TimeSeriesRequest.Builder<?> builder;
        protected U syncResponse;

        private RequestProxy() {
        }

        public T forSymbol(String symbol) {
            this.builder.forSymbol(symbol);
            return (T)this;
        }

        public T dataType(DataType type) {
            this.builder.dataType(type);
            return (T)this;
        }

        public T onSuccess(Fetcher.SuccessCallback<?> callback) {
            TimeSeries.this.successCallback = callback;
            return (T)this;
        }

        public T onFailure(Fetcher.FailureCallback callback) {
            TimeSeries.this.failureCallback = callback;
            return (T)this;
        }

        public void fetch() {
            TimeSeries.this.builder = this.builder;
            TimeSeries.this.fetch();
        }

        public void setSyncResponse(U response) {
            this.syncResponse = response;
        }

        public U fetchSync() throws AlphaVantageException {
            Fetcher.SuccessCallback<Object> callback = e -> this.setSyncResponse(e);
            TimeSeries.this.builder = this.builder;
            TimeSeries.this.fetchSync(callback);
            return this.syncResponse;
        }
    }
}

