/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.sector.response;

import com.crazzyghost.alphavantage.parser.Parser;
import com.crazzyghost.alphavantage.sector.response.SectorUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class SectorResponse {
    private MetaData metaData;
    private Map<String, SectorUnit> sectorUnits;
    private String errorMessage;

    private SectorResponse(MetaData metaData, Map<String, SectorUnit> sectorUnits) {
        this.metaData = metaData;
        this.sectorUnits = sectorUnits;
    }

    private SectorResponse(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static SectorResponse of(Map<String, Object> stringObjectMap) {
        SectorParser parser = new SectorParser();
        return (SectorResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public SectorUnit getRealTimePerformance() {
        return this.sectorUnits.getOrDefault("Rank A: Real-Time Performance", null);
    }

    public SectorUnit getOneDayPerformance() {
        return this.sectorUnits.getOrDefault("Rank B: 1 Day Performance", null);
    }

    public SectorUnit getFiveDayPerformance() {
        return this.sectorUnits.getOrDefault("Rank C: 5 Day Performance", null);
    }

    public SectorUnit getOneMonthPerformance() {
        return this.sectorUnits.getOrDefault("Rank D: 1 Month Performance", null);
    }

    public SectorUnit getThreeMonthPerformance() {
        return this.sectorUnits.getOrDefault("Rank E: 3 Month Performance", null);
    }

    public SectorUnit getYearToDatePerformance() {
        return this.sectorUnits.getOrDefault("Rank F: Year-to-Date (YTD) Performance", null);
    }

    public SectorUnit getOneYearPerformance() {
        return this.sectorUnits.getOrDefault("Rank G: 1 Year Performance", null);
    }

    public SectorUnit getThreeYearPerformance() {
        return this.sectorUnits.getOrDefault("Rank H: 3 Year Performance", null);
    }

    public SectorUnit getFiveYearPerformance() {
        return this.sectorUnits.getOrDefault("Rank I: 5 Year Performance", null);
    }

    public SectorUnit getTenYearPerformance() {
        return this.sectorUnits.getOrDefault("Rank J: 10 Year Performance", null);
    }

    public String toString() {
        return "SectorResponse {errorMessage=" + this.errorMessage + ", metaData=" + this.metaData + ", sectorUnits=" + this.sectorUnits + "}";
    }

    public static final class MetaData {
        private String information;
        private String lastRefreshed;

        public MetaData(String information, String lastRefreshed) {
            this.information = information;
            this.lastRefreshed = lastRefreshed;
        }

        public String getInformation() {
            return this.information;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String toString() {
            return "MetaData {information=" + this.information + ", lastRefreshed=" + this.lastRefreshed + "}";
        }
    }

    public static class SectorParser
    extends Parser<SectorResponse> {
        @Override
        public SectorResponse parse(Map<String, Object> stringObjectMap) {
            ArrayList<String> keys2 = new ArrayList<String>(stringObjectMap.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                Map metaDataMap = (Map)stringObjectMap.get(keys2.get(0));
                MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("Information")), String.valueOf(metaDataMap.get("Last Refreshed")));
                keys2.remove(0);
                HashMap<String, SectorUnit> sectorUnits = new HashMap<String, SectorUnit>();
                for (String sectorDescription : keys2) {
                    Map sectorData = (Map)stringObjectMap.get(sectorDescription);
                    SectorUnit sectorUnit = new SectorUnit((String)sectorData.get("Information Technology"), (String)sectorData.get("Consumer Discretionary"), (String)sectorData.get("Health Care"), (String)sectorData.get("Communication Services"), (String)sectorData.get("Real Estate"), (String)sectorData.get("Utilities"), (String)sectorData.get("Financials"), (String)sectorData.get("Materials"), (String)sectorData.get("Industrials"), (String)sectorData.get("Consumer Staples"), (String)sectorData.get("Energy"));
                    sectorUnits.put(sectorDescription, sectorUnit);
                }
                return new SectorResponse(metaData, sectorUnits);
            }
            catch (ClassCastException e) {
                return this.onParseError(stringObjectMap.get(keys2.get(0)).toString());
            }
        }

        @Override
        public SectorResponse onParseError(String error) {
            return new SectorResponse(error);
        }
    }
}

