/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.sector;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.parser.Parser;
import com.crazzyghost.alphavantage.sector.request.SectorRequest;
import com.crazzyghost.alphavantage.sector.response.SectorResponse;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Sector
implements Fetcher {
    private final Config config;
    private final SectorRequest.Builder builder;
    private Fetcher.SuccessCallback<SectorResponse> successCallback;
    private Fetcher.FailureCallback failureCallback;

    public Sector(Config config) {
        this.config = config;
        this.builder = new SectorRequest.Builder();
    }

    public Sector onSuccess(Fetcher.SuccessCallback<SectorResponse> callback) {
        this.successCallback = callback;
        return this;
    }

    public Sector onFailure(Fetcher.FailureCallback callback) {
        this.failureCallback = callback;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SectorResponse fetchSync() throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = null;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            SectorResponse sectorResponse = SectorResponse.of(Parser.parseJSON(response.body().string()));
            return sectorResponse;
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (Sector.this.failureCallback != null) {
                    Sector.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        SectorResponse sectorResponse = SectorResponse.of(Parser.parseJSON(body.string()));
                        if (sectorResponse.getErrorMessage() != null && Sector.this.failureCallback != null) {
                            Sector.this.failureCallback.onFailure(new AlphaVantageException(sectorResponse.getErrorMessage()));
                        }
                        if (Sector.this.successCallback == null) return;
                        Sector.this.successCallback.onSuccess(sectorResponse);
                        return;
                    }
                } else {
                    if (Sector.this.failureCallback == null) return;
                    Sector.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }
        });
    }
}

