/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.parser;

import com.crazzyghost.alphavantage.parser.NoneableDoubleAdapter;
import com.crazzyghost.alphavantage.parser.NoneableLongAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class Parser<T> {
    public abstract T onParseError(String var1);

    public abstract T parse(Map<String, Object> var1);

    public static Map<String, Object> parseJSON(String responseBody) throws IOException {
        if (responseBody == null) {
            throw new IllegalArgumentException();
        }
        Moshi moshi = new Moshi.Builder().add(new NoneableDoubleAdapter()).add(new NoneableLongAdapter()).build();
        ParameterizedType type = Types.newParameterizedType(Map.class, new Type[]{String.class, Object.class});
        JsonAdapter adapter = moshi.adapter(type);
        return (Map)adapter.fromJson(responseBody);
    }

    public static <U> U parseJSON(String responseBody, Class<U> c) throws IOException {
        if (responseBody == null) {
            throw new IllegalArgumentException();
        }
        Moshi moshi = new Moshi.Builder().add(new NoneableDoubleAdapter()).add(new NoneableLongAdapter()).build();
        Class<?> type = Types.getRawType(c);
        JsonAdapter adapter = moshi.adapter((Type)type);
        return (U)adapter.fromJson(responseBody);
    }

    public static <U> List<U> parseJSONList(Object object, Class<U> klass) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Moshi moshi = new Moshi.Builder().add(new NoneableDoubleAdapter()).add(new NoneableLongAdapter()).build();
        ParameterizedType type = Types.newParameterizedType(List.class, new Type[]{klass});
        JsonAdapter adapter = moshi.adapter(type);
        return (List)adapter.fromJsonValue(object);
    }

    public static String toJSON(Map<String, Object> data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        Moshi moshi = new Moshi.Builder().add(new NoneableDoubleAdapter()).add(new NoneableLongAdapter()).build();
        ParameterizedType type = Types.newParameterizedType(Map.class, new Type[]{String.class, Object.class});
        return moshi.adapter(type).toJson(data);
    }

    public static <N extends Number> N getNumberFromString(String s, Function<String, N> parser) {
        Number result = null;
        try {
            result = (Number)parser.apply(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return (N)result;
    }
}

