/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.ultosc;

import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ULTOSCResponse {
    private MetaData metaData;
    private List<SimpleIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private ULTOSCResponse(List<SimpleIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private ULTOSCResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimpleIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static ULTOSCResponse of(Map<String, Object> stringObjectMap) {
        ULTOSCParser parser = new ULTOSCParser();
        return (ULTOSCResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "ULTOSCResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private int timePeriod1;
        private int timePeriod2;
        private int timePeriod3;
        private String timeZone;

        public MetaData() {
            this("", "", "", "", 0, 0, 0, "");
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, int timePeriod1, int timePeriod2, int timePeriod3, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.timePeriod1 = timePeriod1;
            this.timePeriod2 = timePeriod2;
            this.timePeriod3 = timePeriod3;
            this.timeZone = timeZone;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public int getTimePeriod1() {
            return this.timePeriod1;
        }

        public int getTimePeriod2() {
            return this.timePeriod2;
        }

        public int getTimePeriod3() {
            return this.timePeriod3;
        }

        public String toString() {
            return "MetaData {indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", symbol=" + this.symbol + ", timePeriod1=" + this.timePeriod1 + ", timePeriod2=" + this.timePeriod2 + ", timePeriod3=" + this.timePeriod3 + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class ULTOSCParser
    extends DefaultParser<ULTOSCResponse> {
        @Override
        public ULTOSCResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(metaDataMap.get("1: Symbol").toString(), metaDataMap.get("2: Indicator").toString(), metaDataMap.get("3: Last Refreshed").toString(), metaDataMap.get("4: Interval").toString(), Double.valueOf(String.valueOf(metaDataMap.get("5.1: Time Period 1"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("5.2: Time Period 2"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("5.3: Time Period 3"))).intValue(), metaDataMap.get("6: Time Zone").toString());
            ArrayList<SimpleIndicatorUnit> indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                SimpleIndicatorUnit indicatorUnit = new SimpleIndicatorUnit(e.getKey(), Double.parseDouble(m.get("ULTOSC")), "ULTOSC");
                indicatorUnits.add(indicatorUnit);
            }
            return new ULTOSCResponse(indicatorUnits, metaData);
        }

        @Override
        public ULTOSCResponse onParseError(String error) {
            return new ULTOSCResponse(error);
        }
    }
}

