/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.stochrsi;

import com.crazzyghost.alphavantage.indicator.response.stochrsi.STOCHRSIIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class STOCHRSIResponse {
    private MetaData metaData;
    private List<STOCHRSIIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private STOCHRSIResponse(List<STOCHRSIIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private STOCHRSIResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<STOCHRSIIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<STOCHRSIIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static STOCHRSIResponse of(Map<String, Object> stringObjectMap) {
        STOCHRSIParser parser = new STOCHRSIParser();
        return (STOCHRSIResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "STOCHRSIResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private double timePeriod;
        private double fastKPeriod;
        private double fastDPeriod;
        private double fastDMaType;
        private String seriesType;
        private String timeZone;

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, double timePeriod, double fastKPeriod, double fastDPeriod, double fastDMaType, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.timePeriod = timePeriod;
            this.fastKPeriod = fastKPeriod;
            this.fastDPeriod = fastDPeriod;
            this.fastDMaType = fastDMaType;
            this.seriesType = seriesType;
            this.timeZone = timeZone;
        }

        public MetaData() {
            this("", "", "", "", 10.0, 5.0, 3.0, 0.0, "", "");
        }

        public double getFastDMaType() {
            return this.fastDMaType;
        }

        public double getFastDPeriod() {
            return this.fastDPeriod;
        }

        public double getFastKPeriod() {
            return this.fastKPeriod;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public double getTimePeriod() {
            return this.timePeriod;
        }

        public String toString() {
            return "MetaData {fastDMaType=" + this.fastDMaType + ", fastDPeriod=" + this.fastDPeriod + ", fastKPeriod=" + this.fastKPeriod + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", seriesType=" + this.seriesType + ", symbol=" + this.symbol + ", timePeriod=" + this.timePeriod + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class STOCHRSIParser
    extends DefaultParser<STOCHRSIResponse> {
        @Override
        public STOCHRSIResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5: Time Period"))), Double.valueOf(String.valueOf(metaDataMap.get("6.1: FastK Period"))), Double.valueOf(String.valueOf(metaDataMap.get("6.2: FastD Period"))), Double.valueOf(String.valueOf(metaDataMap.get("6.3: FastD MA Type"))), String.valueOf(metaDataMap.get("7: Series Type")), String.valueOf(metaDataMap.get("8: Time Zone")));
            ArrayList<STOCHRSIIndicatorUnit> indicatorUnits = new ArrayList<STOCHRSIIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                STOCHRSIIndicatorUnit indicatorUnit = new STOCHRSIIndicatorUnit(e.getKey(), Double.parseDouble(m.get("FastK")), Double.parseDouble(m.get("FastD")));
                indicatorUnits.add(indicatorUnit);
            }
            return new STOCHRSIResponse(indicatorUnits, metaData);
        }

        @Override
        public STOCHRSIResponse onParseError(String error) {
            return new STOCHRSIResponse(error);
        }
    }
}

