/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.stochf;

import com.crazzyghost.alphavantage.indicator.response.stochf.STOCHFIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class STOCHFResponse {
    private MetaData metaData;
    private List<STOCHFIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private STOCHFResponse(List<STOCHFIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private STOCHFResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<STOCHFIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<STOCHFIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static STOCHFResponse of(Map<String, Object> stringObjectMap) {
        STOCHFParser parser = new STOCHFParser();
        return (STOCHFResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "STOCHFResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private double fastKPeriod;
        private double fastDPeriod;
        private double fastDMaType;
        private String timeZone;

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, double fastKPeriod, double fastDPeriod, double fastDMaType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.fastKPeriod = fastKPeriod;
            this.fastDPeriod = fastDPeriod;
            this.fastDMaType = fastDMaType;
            this.timeZone = timeZone;
        }

        public MetaData() {
            this("", "", "", "", 5.0, 3.0, 0.0, "");
        }

        public double getFastDMaType() {
            return this.fastDMaType;
        }

        public double getFastDPeriod() {
            return this.fastDPeriod;
        }

        public double getFastKPeriod() {
            return this.fastKPeriod;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String toString() {
            return "MetaData {fastDMaType=" + this.fastDMaType + ", fastDPeriod=" + this.fastDPeriod + ", fastKPeriod=" + this.fastKPeriod + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class STOCHFParser
    extends DefaultParser<STOCHFResponse> {
        @Override
        public STOCHFResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5.1: FastK Period"))), Double.valueOf(String.valueOf(metaDataMap.get("5.2: FastD Period"))), Double.valueOf(String.valueOf(metaDataMap.get("5.3: FastD MA Type"))), String.valueOf(metaDataMap.get("6: Time Zone")));
            ArrayList<STOCHFIndicatorUnit> indicatorUnits = new ArrayList<STOCHFIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                STOCHFIndicatorUnit indicatorUnit = new STOCHFIndicatorUnit(e.getKey(), Double.parseDouble(m.get("FastK")), Double.parseDouble(m.get("FastD")));
                indicatorUnits.add(indicatorUnit);
            }
            return new STOCHFResponse(indicatorUnits, metaData);
        }

        @Override
        public STOCHFResponse onParseError(String error) {
            return new STOCHFResponse(error);
        }
    }
}

