/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.sar;

import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SARResponse {
    private MetaData metaData;
    private List<SimpleIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private SARResponse(List<SimpleIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private SARResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimpleIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static SARResponse of(Map<String, Object> stringObjectMap) {
        SARParser parser = new SARParser();
        return (SARResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "SARResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private double acceleration;
        private double maximum;
        private String timeZone;

        public MetaData() {
            this("", "", "", "", 0.0, 0.0, "");
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, double acceleration, double maximum, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.acceleration = acceleration;
            this.maximum = maximum;
            this.timeZone = timeZone;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getMaximum() {
            return this.maximum;
        }

        public String toString() {
            return "MetaData {acceleration=" + this.acceleration + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", maximum=" + this.maximum + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class SARParser
    extends DefaultParser<SARResponse> {
        @Override
        public SARResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5.1: Acceleration"))), Double.valueOf(String.valueOf(metaDataMap.get("5.2: Maximum"))), String.valueOf(metaDataMap.get("6: Time Zone")));
            ArrayList<SimpleIndicatorUnit> indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                SimpleIndicatorUnit indicatorUnit = new SimpleIndicatorUnit(e.getKey(), Double.parseDouble(m.get("SAR")), "SAR");
                indicatorUnits.add(indicatorUnit);
            }
            return new SARResponse(indicatorUnits, metaData);
        }

        @Override
        public SARResponse onParseError(String error) {
            return new SARResponse(error);
        }
    }
}

