/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.mama;

import com.crazzyghost.alphavantage.indicator.response.mama.MAMAIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MAMAResponse {
    private MetaData metaData;
    private List<MAMAIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private MAMAResponse(List<MAMAIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private MAMAResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<MAMAIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<MAMAIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static MAMAResponse of(Map<String, Object> stringObjectMap) {
        MAMAParser parser = new MAMAParser();
        return (MAMAResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "MAMAResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private double fastLimit;
        private double slowLimit;
        private String timeZone;
        private String seriesType;

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, double fastLimit, double slowLimit, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.fastLimit = fastLimit;
            this.slowLimit = slowLimit;
            this.timeZone = timeZone;
            this.seriesType = seriesType;
        }

        public MetaData() {
            this("", "", "", "", 0.1, 0.1, "", "");
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public double getFastLimit() {
            return this.fastLimit;
        }

        public double getSlowLimit() {
            return this.slowLimit;
        }

        public String toString() {
            return "MetaData {fastLimit=" + this.fastLimit + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", seriesType=" + this.seriesType + ", slowLimit=" + this.slowLimit + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class MAMAParser
    extends DefaultParser<MAMAResponse> {
        @Override
        public MAMAResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5.1: Fast Limit"))), Double.valueOf(String.valueOf(metaDataMap.get("5.2: Slow Limit"))), String.valueOf(metaDataMap.get("6: Series Type")), String.valueOf(metaDataMap.get("7: Time Zone")));
            ArrayList<MAMAIndicatorUnit> indicatorUnits = new ArrayList<MAMAIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                MAMAIndicatorUnit indicatorUnit = new MAMAIndicatorUnit(e.getKey(), Double.parseDouble(m.get("FAMA")), Double.parseDouble(m.get("MAMA")));
                indicatorUnits.add(indicatorUnit);
            }
            return new MAMAResponse(indicatorUnits, metaData);
        }

        @Override
        public MAMAResponse onParseError(String error) {
            return new MAMAResponse(error);
        }
    }
}

