/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.macd;

import com.crazzyghost.alphavantage.indicator.response.macd.MACDIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MACDResponse {
    private MetaData metaData;
    private List<MACDIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private MACDResponse(List<MACDIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private MACDResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<MACDIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<MACDIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static MACDResponse of(Map<String, Object> stringObjectMap) {
        MACDParser parser = new MACDParser();
        return (MACDResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "MACDResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private double fastPeriod;
        private double slowPeriod;
        private double signalPeriod;
        private String timeZone;
        private String seriesType;

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, double fastPeriod, double slowPeriod, double signalPeriod, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.fastPeriod = fastPeriod;
            this.slowPeriod = slowPeriod;
            this.signalPeriod = signalPeriod;
            this.seriesType = seriesType;
            this.timeZone = timeZone;
        }

        public MetaData() {
            this("", "", "", "", 12.0, 26.0, 9.0, "", "");
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public double getFastPeriod() {
            return this.fastPeriod;
        }

        public double getSlowPeriod() {
            return this.slowPeriod;
        }

        public double getSignalPeriod() {
            return this.signalPeriod;
        }

        public String toString() {
            return "MetaData {fastPeriod=" + this.fastPeriod + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", seriesType=" + this.seriesType + ", signalPeriod=" + this.signalPeriod + ", slowPeriod=" + this.slowPeriod + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class MACDParser
    extends DefaultParser<MACDResponse> {
        @Override
        public MACDResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5.1: Fast Period"))), Double.valueOf(String.valueOf(metaDataMap.get("5.2: Slow Period"))), Double.valueOf(String.valueOf(metaDataMap.get("5.3: Signal Period"))), String.valueOf(metaDataMap.get("6: Series Type")), String.valueOf(metaDataMap.get("7: Time Zone")));
            ArrayList<MACDIndicatorUnit> indicatorUnits = new ArrayList<MACDIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                MACDIndicatorUnit indicatorUnit = new MACDIndicatorUnit(e.getKey(), Double.parseDouble(m.get("MACD_Hist")), Double.parseDouble(m.get("MACD_Signal")), Double.parseDouble(m.get("MACD")));
                indicatorUnits.add(indicatorUnit);
            }
            return new MACDResponse(indicatorUnits, metaData);
        }

        @Override
        public MACDResponse onParseError(String error) {
            return new MACDResponse(error);
        }
    }
}

