/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response.bbands;

import com.crazzyghost.alphavantage.indicator.response.bbands.BBANDSIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BBANDSResponse {
    private MetaData metaData;
    private List<BBANDSIndicatorUnit> indicatorUnits;
    private String errorMessage;

    private BBANDSResponse(List<BBANDSIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    private BBANDSResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<BBANDSIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<BBANDSIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static BBANDSResponse of(Map<String, Object> stringObjectMap) {
        BBANDSParser parser = new BBANDSParser();
        return (BBANDSResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return this.metaData.indicator.replaceAll("\\s+", "") + "Response{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private int timePeriod;
        private int nbdevup;
        private int nbdevdn;
        private int maType;
        private String seriesType;
        private String timeZone;

        public MetaData() {
            this("", "", "", "", 0, 0, 0, 0, "", "");
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, int timePeriod, int nbdevup, int nbdevdn, int maType, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.timePeriod = timePeriod;
            this.nbdevup = nbdevup;
            this.nbdevdn = nbdevdn;
            this.maType = maType;
            this.seriesType = seriesType;
            this.timeZone = timeZone;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public int getTimePeriod() {
            return this.timePeriod;
        }

        public int getMaType() {
            return this.maType;
        }

        public int getNbdevup() {
            return this.nbdevup;
        }

        public int getNbdevdn() {
            return this.nbdevdn;
        }

        public String toString() {
            return "MetaData {indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", maType=" + this.maType + ", nbdevdn=" + this.nbdevdn + ", nbdevup=" + this.nbdevup + ", seriesType=" + this.seriesType + ", symbol=" + this.symbol + ", timePeriod=" + this.timePeriod + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static class BBANDSParser
    extends DefaultParser<BBANDSResponse> {
        @Override
        public BBANDSResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5: Time Period"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("6.1: Deviation multiplier for upper band"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("6.2: Deviation multiplier for lower band"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("6.3: MA Type"))).intValue(), String.valueOf(metaDataMap.get("7: Series Type")), String.valueOf(metaDataMap.get("8: Time Zone")));
            ArrayList<BBANDSIndicatorUnit> indicatorUnits = new ArrayList<BBANDSIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                BBANDSIndicatorUnit indicatorUnit = new BBANDSIndicatorUnit(e.getKey(), Double.parseDouble(m.get("Real Upper Band").toString()), Double.parseDouble(m.get("Real Lower Band").toString()), Double.parseDouble(m.get("Real Middle Band").toString()));
                indicatorUnits.add(indicatorUnit);
            }
            return new BBANDSResponse(indicatorUnits, metaData);
        }

        @Override
        public BBANDSResponse onParseError(String error) {
            return new BBANDSResponse(error);
        }
    }
}

