/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response;

import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class SeriesResponse {
    protected MetaData metaData;
    protected List<SimpleIndicatorUnit> indicatorUnits;
    protected String errorMessage;

    protected SeriesResponse(List<SimpleIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    protected SeriesResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimpleIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return "SeriesResponse{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private String seriesType;
        private String timeZone;

        public MetaData() {
            this("", "", "", "", "", "");
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.seriesType = seriesType;
            this.timeZone = timeZone;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public String toString() {
            return "MetaData {indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", seriesType=" + this.seriesType + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static abstract class SeriesParser<T>
    extends DefaultParser<T> {
        protected SeriesParser() {
        }

        @Override
        public T parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), String.valueOf(metaDataMap.get("5: Series Type")), String.valueOf(metaDataMap.get("6: Time Zone")));
            ArrayList<SimpleIndicatorUnit> indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                SimpleIndicatorUnit indicatorUnit = new SimpleIndicatorUnit(e.getKey(), Double.parseDouble(m.get(this.getIndicatorKey())), this.getIndicatorKey());
                indicatorUnits.add(indicatorUnit);
            }
            return this.get(indicatorUnits, metaData);
        }

        @Override
        public T onParseError(String error) {
            return this.get(error);
        }

        public abstract T get(List<SimpleIndicatorUnit> var1, MetaData var2);

        public abstract T get(String var1);

        public abstract String getIndicatorKey();
    }
}

