/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response;

import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class PriceOscillatorResponse {
    protected MetaData metaData;
    protected List<SimpleIndicatorUnit> indicatorUnits;
    protected String errorMessage;

    protected PriceOscillatorResponse(List<SimpleIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    protected PriceOscillatorResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimpleIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return this.metaData.indicator.replaceAll("\\s+", "") + "Response{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private int fastPeriod;
        private int slowPeriod;
        private int maType;
        private String seriesType;
        private String timeZone;

        public MetaData() {
            this("", "", "", "", 0, 0, 0, "", "");
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, int fastPeriod, int slowPeriod, int maType, String seriesType, String timeZone) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.fastPeriod = fastPeriod;
            this.slowPeriod = slowPeriod;
            this.maType = maType;
            this.seriesType = seriesType;
            this.timeZone = timeZone;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public int getFastPeriod() {
            return this.fastPeriod;
        }

        public int getSlowPeriod() {
            return this.slowPeriod;
        }

        public int getMaType() {
            return this.maType;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String toString() {
            return "MetaData {fastPeriod=" + this.fastPeriod + ", indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", maType=" + this.maType + ", seriesType=" + this.seriesType + ", slowPeriod=" + this.slowPeriod + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static abstract class PriceOscillatorParser<T>
    extends DefaultParser<T> {
        @Override
        public T parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), Double.valueOf(String.valueOf(metaDataMap.get("5.1: Fast Period"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("5.2: Slow Period"))).intValue(), Double.valueOf(String.valueOf(metaDataMap.get("5.3: MA Type"))).intValue(), String.valueOf(metaDataMap.get("6: Series Type")), String.valueOf(metaDataMap.get("7: Time Zone")));
            ArrayList<SimpleIndicatorUnit> indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                SimpleIndicatorUnit indicatorUnit = new SimpleIndicatorUnit(e.getKey(), Double.parseDouble(m.get(this.getIndicatorKey())), this.getIndicatorKey());
                indicatorUnits.add(indicatorUnit);
            }
            return this.get(indicatorUnits, metaData);
        }

        @Override
        public T onParseError(String error) {
            return this.get(error);
        }

        public abstract T get(List<SimpleIndicatorUnit> var1, MetaData var2);

        public abstract T get(String var1);

        public abstract String getIndicatorKey();
    }
}

