/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator.response;

import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorUnit;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class PeriodicSeriesResponse {
    protected MetaData metaData;
    protected List<SimpleIndicatorUnit> indicatorUnits;
    protected String errorMessage;

    protected PeriodicSeriesResponse(List<SimpleIndicatorUnit> indicatorUnits, MetaData metaData) {
        this.metaData = metaData;
        this.indicatorUnits = indicatorUnits;
        this.errorMessage = null;
    }

    protected PeriodicSeriesResponse(String errorMessage) {
        this.metaData = new MetaData();
        this.indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<SimpleIndicatorUnit> getIndicatorUnits() {
        return this.indicatorUnits;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String toString() {
        return this.metaData.indicator.replaceAll("\\s+", "") + "Response{metaData=" + this.metaData + ",indicatorUnits=" + this.indicatorUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class MetaData {
        private String symbol;
        private String indicator;
        private String lastRefreshed;
        private String interval;
        private String timeZone;
        private String seriesType;
        private int timePeriod;

        public MetaData() {
            this("", "", "", "", "", "", 0);
        }

        public MetaData(String symbol, String indicator, String lastRefreshed, String interval, String timeZone, String seriesType, int timePeriod) {
            this.symbol = symbol;
            this.indicator = indicator;
            this.lastRefreshed = lastRefreshed;
            this.interval = interval;
            this.timeZone = timeZone;
            this.seriesType = seriesType;
            this.timePeriod = timePeriod;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getIndicator() {
            return this.indicator;
        }

        public String getLastRefreshed() {
            return this.lastRefreshed;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public int getTimePeriod() {
            return this.timePeriod;
        }

        public String toString() {
            return "MetaData {indicator=" + this.indicator + ", interval=" + this.interval + ", lastRefreshed=" + this.lastRefreshed + ", seriesType=" + this.seriesType + ", symbol=" + this.symbol + ", timePeriod=" + this.timePeriod + ", timeZone=" + this.timeZone + "}";
        }
    }

    public static abstract class PeriodicSeriesParser<T>
    extends DefaultParser<T> {
        protected PeriodicSeriesParser() {
        }

        @Override
        public T parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> indicatorData) {
            MetaData metaData = new MetaData(String.valueOf(metaDataMap.get("1: Symbol")), String.valueOf(metaDataMap.get("2: Indicator")), String.valueOf(metaDataMap.get("3: Last Refreshed")), String.valueOf(metaDataMap.get("4: Interval")), String.valueOf(metaDataMap.get("7: Time Zone")), String.valueOf(metaDataMap.get("6: Series Type")), (int)Double.parseDouble(String.valueOf(metaDataMap.get("5: Time Period"))));
            ArrayList<SimpleIndicatorUnit> indicatorUnits = new ArrayList<SimpleIndicatorUnit>();
            for (Map.Entry<String, Map<String, String>> e : indicatorData.entrySet()) {
                Map<String, String> m = e.getValue();
                SimpleIndicatorUnit indicatorUnit = new SimpleIndicatorUnit(e.getKey(), Double.parseDouble(m.get(this.getIndicatorKey())), this.getIndicatorKey());
                indicatorUnits.add(indicatorUnit);
            }
            return this.get(indicatorUnits, metaData);
        }

        @Override
        public T onParseError(String error) {
            return this.get(error);
        }

        protected abstract T get(List<SimpleIndicatorUnit> var1, MetaData var2);

        protected abstract T get(String var1);

        protected abstract String getIndicatorKey();
    }
}

