/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.indicator;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.indicator.request.ADOSCRequest;
import com.crazzyghost.alphavantage.indicator.request.BBANDSRequest;
import com.crazzyghost.alphavantage.indicator.request.IndicatorRequest;
import com.crazzyghost.alphavantage.indicator.request.MACDEXTRequest;
import com.crazzyghost.alphavantage.indicator.request.MACDRequest;
import com.crazzyghost.alphavantage.indicator.request.MAMARequest;
import com.crazzyghost.alphavantage.indicator.request.PeriodicRequest;
import com.crazzyghost.alphavantage.indicator.request.PeriodicSeriesRequest;
import com.crazzyghost.alphavantage.indicator.request.PriceOscillatorRequest;
import com.crazzyghost.alphavantage.indicator.request.SARRequest;
import com.crazzyghost.alphavantage.indicator.request.STOCHFRequest;
import com.crazzyghost.alphavantage.indicator.request.STOCHRSIRequest;
import com.crazzyghost.alphavantage.indicator.request.STOCHRequest;
import com.crazzyghost.alphavantage.indicator.request.SeriesRequest;
import com.crazzyghost.alphavantage.indicator.request.SimpleIndicatorRequest;
import com.crazzyghost.alphavantage.indicator.request.ULTOSCRequest;
import com.crazzyghost.alphavantage.indicator.response.PeriodicResponse;
import com.crazzyghost.alphavantage.indicator.response.PeriodicSeriesResponse;
import com.crazzyghost.alphavantage.indicator.response.PriceOscillatorResponse;
import com.crazzyghost.alphavantage.indicator.response.SeriesResponse;
import com.crazzyghost.alphavantage.indicator.response.SimpleIndicatorResponse;
import com.crazzyghost.alphavantage.indicator.response.ad.ADResponse;
import com.crazzyghost.alphavantage.indicator.response.adosc.ADOSCResponse;
import com.crazzyghost.alphavantage.indicator.response.adx.ADXResponse;
import com.crazzyghost.alphavantage.indicator.response.adxr.ADXRResponse;
import com.crazzyghost.alphavantage.indicator.response.apo.APOResponse;
import com.crazzyghost.alphavantage.indicator.response.aroon.AROONResponse;
import com.crazzyghost.alphavantage.indicator.response.aroonosc.AROONOSCResponse;
import com.crazzyghost.alphavantage.indicator.response.atr.ATRResponse;
import com.crazzyghost.alphavantage.indicator.response.bbands.BBANDSResponse;
import com.crazzyghost.alphavantage.indicator.response.bop.BOPResponse;
import com.crazzyghost.alphavantage.indicator.response.cci.CCIResponse;
import com.crazzyghost.alphavantage.indicator.response.cmo.CMOResponse;
import com.crazzyghost.alphavantage.indicator.response.dema.DEMAResponse;
import com.crazzyghost.alphavantage.indicator.response.dx.DXResponse;
import com.crazzyghost.alphavantage.indicator.response.ema.EMAResponse;
import com.crazzyghost.alphavantage.indicator.response.htdcperiod.HTDCPERIODResponse;
import com.crazzyghost.alphavantage.indicator.response.htdcphase.HTDCPHASEResponse;
import com.crazzyghost.alphavantage.indicator.response.htphasor.HTPHASORResponse;
import com.crazzyghost.alphavantage.indicator.response.htsine.HTSINEResponse;
import com.crazzyghost.alphavantage.indicator.response.httrendline.HTTRENDLINEResponse;
import com.crazzyghost.alphavantage.indicator.response.httrendmode.HTTRENDMODEResponse;
import com.crazzyghost.alphavantage.indicator.response.kama.KAMAResponse;
import com.crazzyghost.alphavantage.indicator.response.macd.MACDEXTResponse;
import com.crazzyghost.alphavantage.indicator.response.macd.MACDResponse;
import com.crazzyghost.alphavantage.indicator.response.mama.MAMAResponse;
import com.crazzyghost.alphavantage.indicator.response.mfi.MFIResponse;
import com.crazzyghost.alphavantage.indicator.response.midpoint.MIDPOINTResponse;
import com.crazzyghost.alphavantage.indicator.response.midprice.MIDPRICEResponse;
import com.crazzyghost.alphavantage.indicator.response.minusdi.MINUSDIResponse;
import com.crazzyghost.alphavantage.indicator.response.minusdm.MINUSDMResponse;
import com.crazzyghost.alphavantage.indicator.response.mom.MOMResponse;
import com.crazzyghost.alphavantage.indicator.response.natr.NATRResponse;
import com.crazzyghost.alphavantage.indicator.response.obv.OBVResponse;
import com.crazzyghost.alphavantage.indicator.response.plusdi.PLUSDIResponse;
import com.crazzyghost.alphavantage.indicator.response.plusdm.PLUSDMResponse;
import com.crazzyghost.alphavantage.indicator.response.ppo.PPOResponse;
import com.crazzyghost.alphavantage.indicator.response.roc.ROCResponse;
import com.crazzyghost.alphavantage.indicator.response.rocr.ROCRResponse;
import com.crazzyghost.alphavantage.indicator.response.rsi.RSIResponse;
import com.crazzyghost.alphavantage.indicator.response.sar.SARResponse;
import com.crazzyghost.alphavantage.indicator.response.sma.SMAResponse;
import com.crazzyghost.alphavantage.indicator.response.stoch.STOCHResponse;
import com.crazzyghost.alphavantage.indicator.response.stochf.STOCHFResponse;
import com.crazzyghost.alphavantage.indicator.response.stochrsi.STOCHRSIResponse;
import com.crazzyghost.alphavantage.indicator.response.t3.T3Response;
import com.crazzyghost.alphavantage.indicator.response.tema.TEMAResponse;
import com.crazzyghost.alphavantage.indicator.response.trange.TRANGEResponse;
import com.crazzyghost.alphavantage.indicator.response.trima.TRIMAResponse;
import com.crazzyghost.alphavantage.indicator.response.trix.TRIXResponse;
import com.crazzyghost.alphavantage.indicator.response.ultosc.ULTOSCResponse;
import com.crazzyghost.alphavantage.indicator.response.vwap.VWAPResponse;
import com.crazzyghost.alphavantage.indicator.response.willr.WILLRResponse;
import com.crazzyghost.alphavantage.indicator.response.wma.WMAResponse;
import com.crazzyghost.alphavantage.parameters.DataType;
import com.crazzyghost.alphavantage.parameters.Function;
import com.crazzyghost.alphavantage.parameters.Interval;
import com.crazzyghost.alphavantage.parameters.MAType;
import com.crazzyghost.alphavantage.parameters.SeriesType;
import com.crazzyghost.alphavantage.parser.Parser;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Indicator
implements Fetcher {
    private IndicatorRequest.Builder<?> builder;
    private Fetcher.SuccessCallback<?> successCallback;
    private Fetcher.FailureCallback failureCallback;
    private final Config config;

    public Indicator(Config config) {
        this.config = config;
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (Indicator.this.failureCallback != null) {
                    Indicator.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    if (Indicator.this.failureCallback != null) {
                        Indicator.this.failureCallback.onFailure(new AlphaVantageException());
                    }
                } else {
                    try (ResponseBody body = response.body();){
                        Indicator.this.parseIndicatorResponse(Parser.parseJSON(body.string()));
                    }
                }
            }
        });
    }

    private void fetchSync(Fetcher.SuccessCallback<?> successCallback) throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = successCallback;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            this.parseIndicatorResponse(Parser.parseJSON(response.body().string()));
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    private void parsePeriodicSeriesResponse(Map<String, Object> data) {
        PeriodicSeriesResponse response = null;
        switch (this.builder.function) {
            case SMA: {
                response = SMAResponse.of(data);
                break;
            }
            case EMA: {
                response = EMAResponse.of(data);
                break;
            }
            case WMA: {
                response = WMAResponse.of(data);
                break;
            }
            case DEMA: {
                response = DEMAResponse.of(data);
                break;
            }
            case TEMA: {
                response = TEMAResponse.of(data);
                break;
            }
            case TRIMA: {
                response = TRIMAResponse.of(data);
                break;
            }
            case KAMA: {
                response = KAMAResponse.of(data);
                break;
            }
            case T3: {
                response = T3Response.of(data);
                break;
            }
            case RSI: {
                response = RSIResponse.of(data);
                break;
            }
            case MOM: {
                response = MOMResponse.of(data);
                break;
            }
            case CMO: {
                response = CMOResponse.of(data);
                break;
            }
            case ROC: {
                response = ROCResponse.of(data);
                break;
            }
            case ROCR: {
                response = ROCRResponse.of(data);
                break;
            }
            case TRIX: {
                response = TRIXResponse.of(data);
                break;
            }
            case MIDPOINT: {
                response = MIDPOINTResponse.of(data);
            }
        }
        if (Objects.nonNull(response) && Objects.nonNull(response.getErrorMessage()) && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseMAMAResponse(Map<String, Object> data) {
        MAMAResponse response = MAMAResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSimpleIndicatorResponse(Map<String, Object> data) {
        SimpleIndicatorResponse response = null;
        switch (this.builder.function) {
            case VWAP: {
                response = VWAPResponse.of(data);
                break;
            }
            case BOP: {
                response = BOPResponse.of(data);
                break;
            }
            case TRANGE: {
                response = TRANGEResponse.of(data);
                break;
            }
            case AD: {
                response = ADResponse.of(data);
                break;
            }
            case OBV: {
                response = OBVResponse.of(data);
            }
        }
        if (Objects.nonNull(response) && Objects.nonNull(response.getErrorMessage()) && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseMACDResponse(Map<String, Object> data) {
        MACDResponse response = MACDResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseMACDEXTResponse(Map<String, Object> data) {
        MACDEXTResponse response = MACDEXTResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSTOCHResponse(Map<String, Object> data) {
        STOCHResponse response = STOCHResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSTOCHFResponse(Map<String, Object> data) {
        STOCHFResponse response = STOCHFResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSTOCHRSIResponse(Map<String, Object> data) {
        STOCHRSIResponse response = STOCHRSIResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parsePriceOscillatorResponse(Map<String, Object> data) {
        PriceOscillatorResponse response = null;
        switch (this.builder.function) {
            case APO: {
                response = APOResponse.of(data);
                break;
            }
            case PPO: {
                response = PPOResponse.of(data);
            }
        }
        if (Objects.nonNull(response) && Objects.nonNull(response.getErrorMessage()) && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parsePeriodicResponse(Map<String, Object> data) {
        PeriodicResponse response = null;
        switch (this.builder.function) {
            case WILLR: {
                response = WILLRResponse.of(data);
                break;
            }
            case ADX: {
                response = ADXResponse.of(data);
                break;
            }
            case ADXR: {
                response = ADXRResponse.of(data);
                break;
            }
            case CCI: {
                response = CCIResponse.of(data);
                break;
            }
            case AROONOSC: {
                response = AROONOSCResponse.of(data);
                break;
            }
            case MFI: {
                response = MFIResponse.of(data);
                break;
            }
            case DX: {
                response = DXResponse.of(data);
                break;
            }
            case MINUS_DI: {
                response = MINUSDIResponse.of(data);
                break;
            }
            case PLUS_DI: {
                response = PLUSDIResponse.of(data);
                break;
            }
            case MINUS_DM: {
                response = MINUSDMResponse.of(data);
                break;
            }
            case PLUS_DM: {
                response = PLUSDMResponse.of(data);
                break;
            }
            case MIDPRICE: {
                response = MIDPRICEResponse.of(data);
                break;
            }
            case ATR: {
                response = ATRResponse.of(data);
                break;
            }
            case NATR: {
                response = NATRResponse.of(data);
            }
        }
        if (Objects.nonNull(response) && Objects.nonNull(response.getErrorMessage()) && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseAROONResponse(Map<String, Object> data) {
        AROONResponse response = AROONResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseULTOSCResponse(Map<String, Object> data) {
        ULTOSCResponse response = ULTOSCResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseBBANDSResponse(Map<String, Object> data) {
        BBANDSResponse response = BBANDSResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSARResponse(Map<String, Object> data) {
        SARResponse response = SARResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseADOSCResponse(Map<String, Object> data) {
        ADOSCResponse response = ADOSCResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseSeriesResponse(Map<String, Object> data) {
        SeriesResponse response = null;
        switch (this.builder.function) {
            case HT_TRENDLINE: {
                response = HTTRENDLINEResponse.of(data);
                break;
            }
            case HT_TRENDMODE: {
                response = HTTRENDMODEResponse.of(data);
                break;
            }
            case HT_DCPERIOD: {
                response = HTDCPERIODResponse.of(data);
                break;
            }
            case HT_DCPHASE: {
                response = HTDCPHASEResponse.of(data);
            }
        }
        if (Objects.nonNull(response) && Objects.nonNull(response.getErrorMessage()) && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseHTSINEResponse(Map<String, Object> data) {
        HTSINEResponse response = HTSINEResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseHTPHASORResponse(Map<String, Object> data) {
        HTPHASORResponse response = HTPHASORResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseIndicatorResponse(Map<String, Object> data) {
        switch (this.builder.function) {
            case SMA: 
            case EMA: 
            case WMA: 
            case DEMA: 
            case TEMA: 
            case TRIMA: 
            case KAMA: 
            case T3: 
            case RSI: 
            case MOM: 
            case CMO: 
            case ROC: 
            case ROCR: 
            case TRIX: 
            case MIDPOINT: {
                this.parsePeriodicSeriesResponse(data);
                break;
            }
            case MAMA: {
                this.parseMAMAResponse(data);
                break;
            }
            case VWAP: 
            case BOP: 
            case TRANGE: 
            case AD: 
            case OBV: {
                this.parseSimpleIndicatorResponse(data);
                break;
            }
            case MACD: {
                this.parseMACDResponse(data);
                break;
            }
            case MACDEXT: {
                this.parseMACDEXTResponse(data);
                break;
            }
            case STOCH: {
                this.parseSTOCHResponse(data);
                break;
            }
            case STOCHF: {
                this.parseSTOCHFResponse(data);
                break;
            }
            case STOCHRSI: {
                this.parseSTOCHRSIResponse(data);
                break;
            }
            case APO: 
            case PPO: {
                this.parsePriceOscillatorResponse(data);
                break;
            }
            case WILLR: 
            case ADX: 
            case ADXR: 
            case CCI: 
            case AROONOSC: 
            case MFI: 
            case DX: 
            case MINUS_DI: 
            case PLUS_DI: 
            case MINUS_DM: 
            case PLUS_DM: 
            case MIDPRICE: 
            case ATR: 
            case NATR: {
                this.parsePeriodicResponse(data);
                break;
            }
            case AROON: {
                this.parseAROONResponse(data);
                break;
            }
            case ULTOSC: {
                this.parseULTOSCResponse(data);
                break;
            }
            case BBANDS: {
                this.parseBBANDSResponse(data);
                break;
            }
            case SAR: {
                this.parseSARResponse(data);
                break;
            }
            case ADOSC: {
                this.parseADOSCResponse(data);
                break;
            }
            case HT_TRENDLINE: 
            case HT_TRENDMODE: 
            case HT_DCPERIOD: 
            case HT_DCPHASE: {
                this.parseSeriesResponse(data);
                break;
            }
            case HT_SINE: {
                this.parseHTSINEResponse(data);
                break;
            }
            case HT_PHASOR: {
                this.parseHTPHASORResponse(data);
                break;
            }
        }
    }

    public PeriodicSeriesRequestProxy<SMAResponse> sma() {
        return new PeriodicSeriesRequestProxy<SMAResponse>(Function.SMA);
    }

    public PeriodicSeriesRequestProxy<EMAResponse> ema() {
        return new PeriodicSeriesRequestProxy<EMAResponse>(Function.EMA);
    }

    public PeriodicSeriesRequestProxy<WMAResponse> wma() {
        return new PeriodicSeriesRequestProxy<WMAResponse>(Function.WMA);
    }

    public PeriodicSeriesRequestProxy<DEMAResponse> dema() {
        return new PeriodicSeriesRequestProxy<DEMAResponse>(Function.DEMA);
    }

    public PeriodicSeriesRequestProxy<TEMAResponse> tema() {
        return new PeriodicSeriesRequestProxy<TEMAResponse>(Function.TEMA);
    }

    public PeriodicSeriesRequestProxy<TRIMAResponse> trima() {
        return new PeriodicSeriesRequestProxy<TRIMAResponse>(Function.TRIMA);
    }

    public PeriodicSeriesRequestProxy<KAMAResponse> kama() {
        return new PeriodicSeriesRequestProxy<KAMAResponse>(Function.KAMA);
    }

    public MAMARequestProxy mama() {
        return new MAMARequestProxy();
    }

    public PeriodicSeriesRequestProxy<T3Response> t3() {
        return new PeriodicSeriesRequestProxy<T3Response>(Function.T3);
    }

    public SimpleIndicatorRequestProxy<?, VWAPResponse> vwap() {
        return new SimpleIndicatorRequestProxy(Function.VWAP);
    }

    public MACDRequestProxy macd() {
        return new MACDRequestProxy();
    }

    public MACDEXTRequestProxy macdext() {
        return new MACDEXTRequestProxy();
    }

    public STOCHRequestProxy stoch() {
        return new STOCHRequestProxy();
    }

    public STOCHFRequestProxy stochf() {
        return new STOCHFRequestProxy();
    }

    public PeriodicSeriesRequestProxy<RSIResponse> rsi() {
        return new PeriodicSeriesRequestProxy<RSIResponse>(Function.RSI);
    }

    public STOCHRSIRequestProxy stochrsi() {
        return new STOCHRSIRequestProxy();
    }

    public PeriodicRequestProxy<WILLRResponse> willr() {
        return new PeriodicRequestProxy<WILLRResponse>(Function.WILLR);
    }

    public PeriodicRequestProxy<ADXResponse> adx() {
        return new PeriodicRequestProxy<ADXResponse>(Function.ADX);
    }

    public PeriodicRequestProxy<ADXRResponse> adxr() {
        return new PeriodicRequestProxy<ADXRResponse>(Function.ADXR);
    }

    public PriceOscillatorRequestProxy<APOResponse> apo() {
        return new PriceOscillatorRequestProxy<APOResponse>(Function.APO);
    }

    public PriceOscillatorRequestProxy<PPOResponse> ppo() {
        return new PriceOscillatorRequestProxy<PPOResponse>(Function.PPO);
    }

    public PeriodicSeriesRequestProxy<MOMResponse> mom() {
        return new PeriodicSeriesRequestProxy<MOMResponse>(Function.MOM);
    }

    public SimpleIndicatorRequestProxy<?, BOPResponse> bop() {
        return new SimpleIndicatorRequestProxy(Function.BOP);
    }

    public PeriodicRequestProxy<CCIResponse> cci() {
        return new PeriodicRequestProxy<CCIResponse>(Function.CCI);
    }

    public PeriodicSeriesRequestProxy<CMOResponse> cmo() {
        return new PeriodicSeriesRequestProxy<CMOResponse>(Function.CMO);
    }

    public PeriodicSeriesRequestProxy<ROCResponse> roc() {
        return new PeriodicSeriesRequestProxy<ROCResponse>(Function.ROC);
    }

    public PeriodicSeriesRequestProxy<ROCRResponse> rocr() {
        return new PeriodicSeriesRequestProxy<ROCRResponse>(Function.ROCR);
    }

    public PeriodicRequestProxy<AROONResponse> aroon() {
        return new PeriodicRequestProxy<AROONResponse>(Function.AROON);
    }

    public PeriodicRequestProxy<AROONOSCResponse> aroonosc() {
        return new PeriodicRequestProxy<AROONOSCResponse>(Function.AROONOSC);
    }

    public PeriodicRequestProxy<MFIResponse> mfi() {
        return new PeriodicRequestProxy<MFIResponse>(Function.MFI);
    }

    public PeriodicSeriesRequestProxy<TRIXResponse> trix() {
        return new PeriodicSeriesRequestProxy<TRIXResponse>(Function.TRIX);
    }

    public ULTOSCRequestProxy ultosc() {
        return new ULTOSCRequestProxy();
    }

    public PeriodicRequestProxy<DXResponse> dx() {
        return new PeriodicRequestProxy<DXResponse>(Function.DX);
    }

    public PeriodicRequestProxy<MINUSDIResponse> minusdi() {
        return new PeriodicRequestProxy<MINUSDIResponse>(Function.MINUS_DI);
    }

    public PeriodicRequestProxy<PLUSDIResponse> plusdi() {
        return new PeriodicRequestProxy<PLUSDIResponse>(Function.PLUS_DI);
    }

    public PeriodicRequestProxy<MINUSDMResponse> minusdm() {
        return new PeriodicRequestProxy<MINUSDMResponse>(Function.MINUS_DM);
    }

    public PeriodicRequestProxy<PLUSDMResponse> plusdm() {
        return new PeriodicRequestProxy<PLUSDMResponse>(Function.PLUS_DM);
    }

    public BBANDSRequestProxy bbands() {
        return new BBANDSRequestProxy();
    }

    public PeriodicSeriesRequestProxy<MIDPOINTResponse> midpoint() {
        return new PeriodicSeriesRequestProxy<MIDPOINTResponse>(Function.MIDPOINT);
    }

    public PeriodicRequestProxy<MIDPRICEResponse> midprice() {
        return new PeriodicRequestProxy<MIDPRICEResponse>(Function.MIDPRICE);
    }

    public SARRequestProxy sar() {
        return new SARRequestProxy();
    }

    public SimpleIndicatorRequestProxy<?, TRANGEResponse> trange() {
        return new SimpleIndicatorRequestProxy(Function.TRANGE);
    }

    public PeriodicRequestProxy<ATRResponse> atr() {
        return new PeriodicRequestProxy<ATRResponse>(Function.ATR);
    }

    public PeriodicRequestProxy<NATRResponse> natr() {
        return new PeriodicRequestProxy<NATRResponse>(Function.NATR);
    }

    public SimpleIndicatorRequestProxy<?, ADResponse> ad() {
        return new SimpleIndicatorRequestProxy(Function.AD);
    }

    public ADOSCRequestProxy adosc() {
        return new ADOSCRequestProxy();
    }

    public SimpleIndicatorRequestProxy<?, OBVResponse> obv() {
        return new SimpleIndicatorRequestProxy(Function.OBV);
    }

    public SeriesRequestProxy<HTTRENDLINEResponse> httrendline() {
        return new SeriesRequestProxy<HTTRENDLINEResponse>(Function.HT_TRENDLINE);
    }

    public SeriesRequestProxy<HTSINEResponse> htsine() {
        return new SeriesRequestProxy<HTSINEResponse>(Function.HT_SINE);
    }

    public SeriesRequestProxy<HTTRENDMODEResponse> httrendmode() {
        return new SeriesRequestProxy<HTTRENDMODEResponse>(Function.HT_TRENDMODE);
    }

    public SeriesRequestProxy<HTDCPHASEResponse> htdcphase() {
        return new SeriesRequestProxy<HTDCPHASEResponse>(Function.HT_DCPHASE);
    }

    public SeriesRequestProxy<HTDCPERIODResponse> htdcperiod() {
        return new SeriesRequestProxy<HTDCPERIODResponse>(Function.HT_DCPERIOD);
    }

    public SeriesRequestProxy<HTPHASORResponse> htphasor() {
        return new SeriesRequestProxy<HTPHASORResponse>(Function.HT_PHASOR);
    }

    public class ADOSCRequestProxy
    extends SimpleIndicatorRequestProxy<ADOSCRequestProxy, ADOSCResponse> {
        public ADOSCRequestProxy() {
            this.builder = new ADOSCRequest.Builder();
        }

        public ADOSCRequestProxy fastPeriod(int period) {
            this.builder = ((ADOSCRequest.Builder)this.builder).fastPeriod(period);
            return this;
        }

        public ADOSCRequestProxy slowPeriod(int period) {
            this.builder = ((ADOSCRequest.Builder)this.builder).slowPeriod(period);
            return this;
        }
    }

    public class SARRequestProxy
    extends SimpleIndicatorRequestProxy<SARRequestProxy, SARResponse> {
        public SARRequestProxy() {
            this.builder = new SARRequest.Builder();
        }

        public SARRequestProxy acceleration(double acceleration) {
            this.builder = ((SARRequest.Builder)this.builder).acceleration(acceleration);
            return this;
        }

        public SARRequestProxy maximum(double maximum) {
            this.builder = ((SARRequest.Builder)this.builder).maximum(maximum);
            return this;
        }
    }

    public class BBANDSRequestProxy
    extends SimpleIndicatorRequestProxy<BBANDSRequestProxy, BBANDSResponse> {
        public BBANDSRequestProxy() {
            this.builder = new BBANDSRequest.Builder();
        }

        public BBANDSRequestProxy nbdevup(int dev) {
            this.builder = ((BBANDSRequest.Builder)this.builder).nbdevup(dev);
            return this;
        }

        public BBANDSRequestProxy nbdevdn(int dev) {
            this.builder = ((BBANDSRequest.Builder)this.builder).nbdevdn(dev);
            return this;
        }

        public BBANDSRequestProxy maType(MAType type) {
            this.builder = ((BBANDSRequest.Builder)this.builder).maType(type);
            return this;
        }

        public BBANDSRequestProxy timePeriod(int period) {
            this.builder = ((BBANDSRequest.Builder)this.builder).timePeriod(period);
            return this;
        }

        public BBANDSRequestProxy seriesType(SeriesType series) {
            this.builder = ((BBANDSRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class ULTOSCRequestProxy
    extends SimpleIndicatorRequestProxy<ULTOSCRequestProxy, ULTOSCResponse> {
        public ULTOSCRequestProxy() {
            this.builder = new ULTOSCRequest.Builder();
        }

        public ULTOSCRequestProxy timePeriod1(int period) {
            this.builder = ((ULTOSCRequest.Builder)this.builder).timePeriod1(period);
            return this;
        }

        public ULTOSCRequestProxy timePeriod2(int period) {
            this.builder = ((ULTOSCRequest.Builder)this.builder).timePeriod2(period);
            return this;
        }

        public ULTOSCRequestProxy timePeriod3(int period) {
            this.builder = ((ULTOSCRequest.Builder)this.builder).timePeriod3(period);
            return this;
        }
    }

    public class PriceOscillatorRequestProxy<T>
    extends SimpleIndicatorRequestProxy<PriceOscillatorRequestProxy<T>, T> {
        public PriceOscillatorRequestProxy(Function function) {
            this.builder = new PriceOscillatorRequest.Builder();
            this.builder = this.builder.function(function);
        }

        public PriceOscillatorRequestProxy<T> fastPeriod(int period) {
            this.builder = ((PriceOscillatorRequest.Builder)this.builder).fastPeriod(period);
            return this;
        }

        public PriceOscillatorRequestProxy<T> slowPeriod(int period) {
            this.builder = ((PriceOscillatorRequest.Builder)this.builder).slowPeriod(period);
            return this;
        }

        public PriceOscillatorRequestProxy<T> seriesType(SeriesType series) {
            this.builder = ((PriceOscillatorRequest.Builder)this.builder).seriesType(series);
            return this;
        }

        public PriceOscillatorRequestProxy<T> maType(MAType type) {
            this.builder = ((PriceOscillatorRequest.Builder)this.builder).maType(type);
            return this;
        }
    }

    public class STOCHRSIRequestProxy
    extends SimpleIndicatorRequestProxy<STOCHRSIRequestProxy, STOCHRSIResponse> {
        public STOCHRSIRequestProxy() {
            this.builder = new STOCHRSIRequest.Builder();
        }

        public STOCHRSIRequestProxy fastKPeriod(int period) {
            this.builder = ((STOCHRSIRequest.Builder)this.builder).fastKPeriod(period);
            return this;
        }

        public STOCHRSIRequestProxy fastDPeriod(int period) {
            this.builder = ((STOCHRSIRequest.Builder)this.builder).fastDPeriod(period);
            return this;
        }

        public STOCHRSIRequestProxy fastDMaType(MAType type) {
            this.builder = ((STOCHRSIRequest.Builder)this.builder).fastDMaType(type);
            return this;
        }

        public STOCHRSIRequestProxy timePeriod(int period) {
            this.builder = ((STOCHRSIRequest.Builder)this.builder).timePeriod(period);
            return this;
        }

        public STOCHRSIRequestProxy seriesType(SeriesType series) {
            this.builder = ((STOCHRSIRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class STOCHFRequestProxy
    extends SimpleIndicatorRequestProxy<STOCHFRequestProxy, STOCHFResponse> {
        public STOCHFRequestProxy() {
            this.builder = new STOCHFRequest.Builder();
        }

        public STOCHFRequestProxy fastKPeriod(int period) {
            this.builder = ((STOCHFRequest.Builder)this.builder).fastKPeriod(period);
            return this;
        }

        public STOCHFRequestProxy fastDPeriod(int period) {
            this.builder = ((STOCHFRequest.Builder)this.builder).fastDPeriod(period);
            return this;
        }

        public STOCHFRequestProxy fastDMaType(MAType type) {
            this.builder = ((STOCHFRequest.Builder)this.builder).fastDMaType(type);
            return this;
        }
    }

    public class STOCHRequestProxy
    extends SimpleIndicatorRequestProxy<STOCHRequestProxy, STOCHResponse> {
        public STOCHRequestProxy() {
            this.builder = new STOCHRequest.Builder();
        }

        public STOCHRequestProxy fastKPeriod(int period) {
            this.builder = ((STOCHRequest.Builder)this.builder).fastKPeriod(period);
            return this;
        }

        public STOCHRequestProxy slowKPeriod(int period) {
            this.builder = ((STOCHRequest.Builder)this.builder).slowKPeriod(period);
            return this;
        }

        public STOCHRequestProxy slowDPeriod(int period) {
            this.builder = ((STOCHRequest.Builder)this.builder).slowDPeriod(period);
            return this;
        }

        public STOCHRequestProxy slowKMaType(MAType type) {
            this.builder = ((STOCHRequest.Builder)this.builder).slowKMaType(type);
            return this;
        }

        public STOCHRequestProxy slowDMaType(MAType type) {
            this.builder = ((STOCHRequest.Builder)this.builder).slowDMaType(type);
            return this;
        }
    }

    public class MACDEXTRequestProxy
    extends SimpleIndicatorRequestProxy<MACDEXTRequestProxy, MACDEXTResponse> {
        public MACDEXTRequestProxy() {
            this.builder = new MACDEXTRequest.Builder();
        }

        public MACDEXTRequestProxy fastPeriod(int period) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).fastPeriod(period);
            return this;
        }

        public MACDEXTRequestProxy slowPeriod(int period) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).slowPeriod(period);
            return this;
        }

        public MACDEXTRequestProxy signalPeriod(int period) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).signalPeriod(period);
            return this;
        }

        public MACDEXTRequestProxy fastMaType(MAType type) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).fastMaType(type);
            return this;
        }

        public MACDEXTRequestProxy slowMaType(MAType type) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).slowMaType(type);
            return this;
        }

        public MACDEXTRequestProxy signalMaType(MAType type) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).signalMaType(type);
            return this;
        }

        public MACDEXTRequestProxy seriesType(SeriesType series) {
            this.builder = ((MACDEXTRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class MACDRequestProxy
    extends SimpleIndicatorRequestProxy<MACDRequestProxy, MACDResponse> {
        public MACDRequestProxy() {
            this.builder = new MACDRequest.Builder();
        }

        public MACDRequestProxy fastPeriod(int fastLimit) {
            this.builder = ((MACDRequest.Builder)this.builder).fastPeriod(fastLimit);
            return this;
        }

        public MACDRequestProxy slowPeriod(int slowPeriod) {
            this.builder = ((MACDRequest.Builder)this.builder).slowPeriod(slowPeriod);
            return this;
        }

        public MACDRequestProxy signalPeriod(int signalPeriod) {
            this.builder = ((MACDRequest.Builder)this.builder).signalPeriod(signalPeriod);
            return this;
        }

        public MACDRequestProxy seriesType(SeriesType series) {
            this.builder = ((MACDRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class MAMARequestProxy
    extends SimpleIndicatorRequestProxy<MAMARequestProxy, MAMAResponse> {
        public MAMARequestProxy() {
            this.builder = new MAMARequest.Builder();
        }

        public MAMARequestProxy fastLimit(double fastLimit) {
            this.builder = ((MAMARequest.Builder)this.builder).fastLimit(fastLimit);
            return this;
        }

        public MAMARequestProxy seriesType(SeriesType series) {
            this.builder = ((MAMARequest.Builder)this.builder).seriesType(series);
            return this;
        }

        public MAMARequestProxy slowLimit(double slowLimit) {
            this.builder = ((MAMARequest.Builder)this.builder).slowLimit(slowLimit);
            return this;
        }
    }

    public class SeriesRequestProxy<T>
    extends SimpleIndicatorRequestProxy<SeriesRequestProxy<T>, T> {
        public SeriesRequestProxy(Function function) {
            this.builder = new SeriesRequest.Builder();
            this.builder = this.builder.function(function);
        }

        public SeriesRequestProxy<T> seriesType(SeriesType series) {
            this.builder = ((SeriesRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class PeriodicRequestProxy<T>
    extends SimpleIndicatorRequestProxy<PeriodicRequestProxy<T>, T> {
        public PeriodicRequestProxy(Function function) {
            this.builder = new PeriodicRequest.Builder();
            this.builder = this.builder.function(function);
        }

        public PeriodicRequestProxy<T> timePeriod(int period) {
            this.builder = ((PeriodicRequest.Builder)this.builder).timePeriod(period);
            return this;
        }
    }

    public class PeriodicSeriesRequestProxy<T>
    extends SimpleIndicatorRequestProxy<PeriodicSeriesRequestProxy<T>, T> {
        public PeriodicSeriesRequestProxy(Function function) {
            this.builder = new PeriodicSeriesRequest.Builder();
            this.builder = this.builder.function(function);
        }

        public PeriodicSeriesRequestProxy<T> timePeriod(int period) {
            this.builder = ((PeriodicSeriesRequest.Builder)this.builder).timePeriod(period);
            return this;
        }

        public PeriodicSeriesRequestProxy<T> seriesType(SeriesType series) {
            this.builder = ((PeriodicSeriesRequest.Builder)this.builder).seriesType(series);
            return this;
        }
    }

    public class SimpleIndicatorRequestProxy<T extends SimpleIndicatorRequestProxy<?, U>, U> {
        protected IndicatorRequest.Builder<?> builder;
        protected U syncResponse;

        public SimpleIndicatorRequestProxy() {
        }

        public SimpleIndicatorRequestProxy(Function function) {
            this.builder = new SimpleIndicatorRequest.Builder();
            this.builder = this.builder.function(function);
        }

        public T dataType(DataType dataType) {
            this.builder = this.builder.dataType(dataType);
            return (T)this;
        }

        public T forSymbol(String symbol) {
            this.builder = this.builder.forSymbol(symbol);
            return (T)this;
        }

        public T interval(Interval interval) {
            this.builder = this.builder.interval(interval);
            return (T)this;
        }

        public T onSuccess(Fetcher.SuccessCallback<?> callback) {
            Indicator.this.successCallback = callback;
            return (T)this;
        }

        public T onFailure(Fetcher.FailureCallback callback) {
            Indicator.this.failureCallback = callback;
            return (T)this;
        }

        public void fetch() {
            Indicator.this.builder = this.builder;
            Indicator.this.fetch();
        }

        private void setSyncResponse(U response) {
            this.syncResponse = response;
        }

        public U fetchSync() throws AlphaVantageException {
            Fetcher.SuccessCallback<Object> callback = e -> this.setSyncResponse(e);
            Indicator.this.builder = this.builder;
            Indicator.this.fetchSync(callback);
            return this.syncResponse;
        }
    }
}

