/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata.response;

import com.crazzyghost.alphavantage.fundamentaldata.response.IncomeStatement;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IncomeStatementResponse {
    private final String symbol;
    private final List<IncomeStatement> annualReports;
    private final List<IncomeStatement> quarterlyReports;
    private final String errorMessage;

    private IncomeStatementResponse(String error) {
        this.errorMessage = error;
        this.annualReports = new ArrayList<IncomeStatement>();
        this.quarterlyReports = new ArrayList<IncomeStatement>();
        this.symbol = null;
    }

    private IncomeStatementResponse(String symbol, List<IncomeStatement> annualReports, List<IncomeStatement> quarterlyReports) {
        this.symbol = symbol;
        this.annualReports = annualReports;
        this.quarterlyReports = quarterlyReports;
        this.errorMessage = null;
    }

    public static IncomeStatementResponse of(Map<String, Object> objectMap) {
        IncomeStatementParser parser = new IncomeStatementParser();
        return (IncomeStatementResponse)((Parser)parser).parse(objectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<IncomeStatement> getAnnualReports() {
        return this.annualReports;
    }

    public List<IncomeStatement> getQuarterlyReports() {
        return this.quarterlyReports;
    }

    public String toString() {
        return "IncomeStatementResponse{symbol='" + this.symbol + '\'' + ", annualReports=" + this.annualReports + ", quarterlyReports=" + this.quarterlyReports + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class IncomeStatementParser
    extends Parser<IncomeStatementResponse> {
        @Override
        public IncomeStatementResponse onParseError(String error) {
            return new IncomeStatementResponse(error);
        }

        @Override
        public IncomeStatementResponse parse(Map<String, Object> object) {
            ArrayList<String> keys2 = new ArrayList<String>(object.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                String symbol = (String)object.get(keys2.get(0));
                List<IncomeStatement> annualReports = Parser.parseJSONList(object.get(keys2.get(1)), IncomeStatement.class);
                List<IncomeStatement> quarterlyReports = Parser.parseJSONList(object.get(keys2.get(2)), IncomeStatement.class);
                return new IncomeStatementResponse(symbol, annualReports, quarterlyReports);
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                return this.onParseError(object.get(keys2.get(0)).toString());
            }
        }
    }
}

