/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata.response;

import com.crazzyghost.alphavantage.fundamentaldata.response.AnnualEarning;
import com.crazzyghost.alphavantage.fundamentaldata.response.QuarterlyEarning;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EarningsResponse {
    private final String symbol;
    private final List<AnnualEarning> annualReports;
    private final List<QuarterlyEarning> quarterlyReports;
    private final String errorMessage;

    private EarningsResponse(String error) {
        this.errorMessage = error;
        this.annualReports = new ArrayList<AnnualEarning>();
        this.quarterlyReports = new ArrayList<QuarterlyEarning>();
        this.symbol = null;
    }

    private EarningsResponse(String symbol, List<AnnualEarning> annualReports, List<QuarterlyEarning> quarterlyReports) {
        this.symbol = symbol;
        this.annualReports = annualReports;
        this.quarterlyReports = quarterlyReports;
        this.errorMessage = null;
    }

    public static EarningsResponse of(Map<String, Object> objectMap) {
        EarningParser parser = new EarningParser();
        return (EarningsResponse)((Parser)parser).parse(objectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<AnnualEarning> getAnnualReports() {
        return this.annualReports;
    }

    public List<QuarterlyEarning> getQuarterlyReports() {
        return this.quarterlyReports;
    }

    public String toString() {
        return "EarningResponse{symbol='" + this.symbol + '\'' + ", annualReports=" + this.annualReports + ", quarterlyReports=" + this.quarterlyReports + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class EarningParser
    extends Parser<EarningsResponse> {
        @Override
        public EarningsResponse onParseError(String error) {
            return new EarningsResponse(error);
        }

        @Override
        public EarningsResponse parse(Map<String, Object> object) {
            ArrayList<String> keys2 = new ArrayList<String>(object.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                String symbol = (String)object.get(keys2.get(0));
                List<AnnualEarning> annualReports = Parser.parseJSONList(object.get(keys2.get(1)), AnnualEarning.class);
                List<QuarterlyEarning> quarterlyReports = Parser.parseJSONList(object.get(keys2.get(2)), QuarterlyEarning.class);
                return new EarningsResponse(symbol, annualReports, quarterlyReports);
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                return this.onParseError(object.get(keys2.get(0)).toString());
            }
        }
    }
}

