/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata.response;

import com.crazzyghost.alphavantage.fundamentaldata.response.CompanyOverview;
import com.crazzyghost.alphavantage.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class CompanyOverviewResponse {
    private final CompanyOverview overview;
    private final String errorMessage;

    private CompanyOverviewResponse(String error) {
        this.errorMessage = error;
        this.overview = null;
    }

    private CompanyOverviewResponse(CompanyOverview overview) {
        this.overview = overview;
        this.errorMessage = null;
    }

    public static CompanyOverviewResponse of(Map<String, Object> objectMap) {
        CompanyOverviewParser parser = new CompanyOverviewParser();
        return (CompanyOverviewResponse)((Parser)parser).parse(objectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public CompanyOverview getOverview() {
        return this.overview;
    }

    public String toString() {
        return "CompanyOverviewResponse{overview=" + this.overview + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class CompanyOverviewParser
    extends Parser<CompanyOverviewResponse> {
        @Override
        public CompanyOverviewResponse onParseError(String error) {
            return new CompanyOverviewResponse(error);
        }

        @Override
        public CompanyOverviewResponse parse(Map<String, Object> data) {
            ArrayList<String> keys2 = new ArrayList<String>(data.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                Object symbol = data.getOrDefault("Symbol", null);
                if (symbol == null) {
                    throw new ClassCastException();
                }
                CompanyOverview overview = Parser.parseJSON(Parser.toJSON(data), CompanyOverview.class);
                return new CompanyOverviewResponse(overview);
            }
            catch (IOException | ClassCastException e) {
                return this.onParseError(data.get(keys2.get(0)).toString());
            }
        }
    }
}

