/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata.response;

import com.crazzyghost.alphavantage.fundamentaldata.response.CashFlow;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CashFlowResponse {
    private final String symbol;
    private final List<CashFlow> annualReports;
    private final List<CashFlow> quarterlyReports;
    private final String errorMessage;

    private CashFlowResponse(String error) {
        this.errorMessage = error;
        this.annualReports = new ArrayList<CashFlow>();
        this.quarterlyReports = new ArrayList<CashFlow>();
        this.symbol = null;
    }

    private CashFlowResponse(String symbol, List<CashFlow> annualReports, List<CashFlow> quarterlyReports) {
        this.symbol = symbol;
        this.annualReports = annualReports;
        this.quarterlyReports = quarterlyReports;
        this.errorMessage = null;
    }

    public static CashFlowResponse of(Map<String, Object> objectMap) {
        CashFlowParser parser = new CashFlowParser();
        return (CashFlowResponse)((Parser)parser).parse(objectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<CashFlow> getAnnualReports() {
        return this.annualReports;
    }

    public List<CashFlow> getQuarterlyReports() {
        return this.quarterlyReports;
    }

    public String toString() {
        return "CashFlowResponse{symbol='" + this.symbol + '\'' + ", annualReports=" + this.annualReports + ", quarterlyReports=" + this.quarterlyReports + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class CashFlowParser
    extends Parser<CashFlowResponse> {
        @Override
        public CashFlowResponse onParseError(String error) {
            return new CashFlowResponse(error);
        }

        @Override
        public CashFlowResponse parse(Map<String, Object> object) {
            ArrayList<String> keys2 = new ArrayList<String>(object.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                String symbol = (String)object.get(keys2.get(0));
                List<CashFlow> annualReports = Parser.parseJSONList(object.get(keys2.get(1)), CashFlow.class);
                List<CashFlow> quarterlyReports = Parser.parseJSONList(object.get(keys2.get(2)), CashFlow.class);
                return new CashFlowResponse(symbol, annualReports, quarterlyReports);
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                return this.onParseError(object.get(keys2.get(0)).toString());
            }
        }
    }
}

