/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata.response;

import com.crazzyghost.alphavantage.fundamentaldata.response.BalanceSheet;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BalanceSheetResponse {
    private final String symbol;
    private final List<BalanceSheet> annualReports;
    private final List<BalanceSheet> quarterlyReports;
    private final String errorMessage;

    private BalanceSheetResponse(String error) {
        this.errorMessage = error;
        this.annualReports = new ArrayList<BalanceSheet>();
        this.quarterlyReports = new ArrayList<BalanceSheet>();
        this.symbol = null;
    }

    private BalanceSheetResponse(String symbol, List<BalanceSheet> annualReports, List<BalanceSheet> quarterlyReports) {
        this.symbol = symbol;
        this.annualReports = annualReports;
        this.quarterlyReports = quarterlyReports;
        this.errorMessage = null;
    }

    public static BalanceSheetResponse of(Map<String, Object> objectMap) {
        BalanceSheetParser parser = new BalanceSheetParser();
        return (BalanceSheetResponse)((Parser)parser).parse(objectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<BalanceSheet> getAnnualReports() {
        return this.annualReports;
    }

    public List<BalanceSheet> getQuarterlyReports() {
        return this.quarterlyReports;
    }

    public String toString() {
        return "BalanceSheetResponse{symbol='" + this.symbol + '\'' + ", annualReports=" + this.annualReports + ", quarterlyReports=" + this.quarterlyReports + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class BalanceSheetParser
    extends Parser<BalanceSheetResponse> {
        @Override
        public BalanceSheetResponse onParseError(String error) {
            return new BalanceSheetResponse(error);
        }

        @Override
        public BalanceSheetResponse parse(Map<String, Object> object) {
            ArrayList<String> keys2 = new ArrayList<String>(object.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                String symbol = (String)object.get(keys2.get(0));
                List<BalanceSheet> annualReports = Parser.parseJSONList(object.get(keys2.get(1)), BalanceSheet.class);
                List<BalanceSheet> quarterlyReports = Parser.parseJSONList(object.get(keys2.get(2)), BalanceSheet.class);
                return new BalanceSheetResponse(symbol, annualReports, quarterlyReports);
            }
            catch (ClassCastException | IndexOutOfBoundsException e) {
                return this.onParseError(object.get(keys2.get(0)).toString());
            }
        }
    }
}

