/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.fundamentaldata;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.fundamentaldata.request.BalanceSheetRequest;
import com.crazzyghost.alphavantage.fundamentaldata.request.CashFlowRequest;
import com.crazzyghost.alphavantage.fundamentaldata.request.CompanyOverviewRequest;
import com.crazzyghost.alphavantage.fundamentaldata.request.EarningsRequest;
import com.crazzyghost.alphavantage.fundamentaldata.request.FundamentalDataRequest;
import com.crazzyghost.alphavantage.fundamentaldata.request.IncomeStatementRequest;
import com.crazzyghost.alphavantage.fundamentaldata.response.BalanceSheetResponse;
import com.crazzyghost.alphavantage.fundamentaldata.response.CashFlowResponse;
import com.crazzyghost.alphavantage.fundamentaldata.response.CompanyOverviewResponse;
import com.crazzyghost.alphavantage.fundamentaldata.response.EarningsResponse;
import com.crazzyghost.alphavantage.fundamentaldata.response.IncomeStatementResponse;
import com.crazzyghost.alphavantage.parser.Parser;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class FundamentalData
implements Fetcher {
    private final Config config;
    private FundamentalDataRequest.Builder<?> builder;
    private Fetcher.SuccessCallback<?> successCallback;
    private Fetcher.FailureCallback failureCallback;

    public FundamentalData(Config config) {
        this.config = config;
    }

    public IncomeStatementRequestProxy incomeStatement() {
        return new IncomeStatementRequestProxy();
    }

    public BalanceSheetRequestProxy balanceSheet() {
        return new BalanceSheetRequestProxy();
    }

    public CashFlowRequestProxy cashFlow() {
        return new CashFlowRequestProxy();
    }

    public EarningsRequestProxy earnings() {
        return new EarningsRequestProxy();
    }

    public CompanyOverViewRequestProxy companyOverview() {
        return new CompanyOverViewRequestProxy();
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (FundamentalData.this.failureCallback != null) {
                    FundamentalData.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    if (FundamentalData.this.failureCallback != null) {
                        FundamentalData.this.failureCallback.onFailure(new AlphaVantageException());
                    }
                } else {
                    try (ResponseBody body = response.body();){
                        FundamentalData.this.parseFundamentalDataResponse(Parser.parseJSON(body.string()));
                    }
                }
            }
        });
    }

    private void fetchSync(Fetcher.SuccessCallback<?> successCallback) throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = successCallback;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            this.parseFundamentalDataResponse(Parser.parseJSON(response.body().string()));
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    private void parseFundamentalDataResponse(Map<String, Object> data) {
        switch (this.builder.function) {
            case OVERVIEW: {
                this.parseCompanyOverviewResponse(data);
                break;
            }
            case BALANCE_SHEET: {
                this.parseBalanceSheetResponse(data);
                break;
            }
            case INCOME_STATEMENT: {
                this.parseIncomeStatementResponse(data);
                break;
            }
            case CASH_FLOW: {
                this.parseCashFlowResponse(data);
                break;
            }
            case EARNINGS: {
                this.parseEarningsResponse(data);
                break;
            }
        }
    }

    private void parseCompanyOverviewResponse(Map<String, Object> data) {
        CompanyOverviewResponse response = CompanyOverviewResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseBalanceSheetResponse(Map<String, Object> data) {
        BalanceSheetResponse response = BalanceSheetResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseIncomeStatementResponse(Map<String, Object> data) {
        IncomeStatementResponse response = IncomeStatementResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseCashFlowResponse(Map<String, Object> data) {
        CashFlowResponse response = CashFlowResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseEarningsResponse(Map<String, Object> data) {
        EarningsResponse response = EarningsResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    public class CompanyOverViewRequestProxy
    extends RequestProxy<CompanyOverViewRequestProxy, CompanyOverviewResponse> {
        public CompanyOverViewRequestProxy() {
            this.builder = new CompanyOverviewRequest.Builder();
        }
    }

    public class EarningsRequestProxy
    extends RequestProxy<EarningsRequestProxy, EarningsResponse> {
        public EarningsRequestProxy() {
            this.builder = new EarningsRequest.Builder();
        }
    }

    public class CashFlowRequestProxy
    extends RequestProxy<CashFlowRequestProxy, CashFlowResponse> {
        public CashFlowRequestProxy() {
            this.builder = new CashFlowRequest.Builder();
        }
    }

    public class BalanceSheetRequestProxy
    extends RequestProxy<BalanceSheetRequestProxy, BalanceSheetResponse> {
        public BalanceSheetRequestProxy() {
            this.builder = new BalanceSheetRequest.Builder();
        }
    }

    public class IncomeStatementRequestProxy
    extends RequestProxy<IncomeStatementRequestProxy, IncomeStatementResponse> {
        public IncomeStatementRequestProxy() {
            this.builder = new IncomeStatementRequest.Builder();
        }
    }

    public abstract class RequestProxy<Proxy extends RequestProxy<?, ProxyResponse>, ProxyResponse> {
        protected FundamentalDataRequest.Builder<?> builder;
        protected ProxyResponse syncResponse;

        private RequestProxy() {
        }

        public Proxy forSymbol(String symbol) {
            this.builder.symbol(symbol);
            return (Proxy)this;
        }

        public Proxy onSuccess(Fetcher.SuccessCallback<?> callback) {
            FundamentalData.this.successCallback = callback;
            return (Proxy)this;
        }

        public Proxy onFailure(Fetcher.FailureCallback callback) {
            FundamentalData.this.failureCallback = callback;
            return (Proxy)this;
        }

        public void fetch() {
            FundamentalData.this.builder = this.builder;
            FundamentalData.this.fetch();
        }

        public void setSyncResponse(ProxyResponse response) {
            this.syncResponse = response;
        }

        public ProxyResponse fetchSync() throws AlphaVantageException {
            Fetcher.SuccessCallback<Object> callback = this::setSyncResponse;
            FundamentalData.this.builder = this.builder;
            FundamentalData.this.fetchSync(callback);
            return this.syncResponse;
        }
    }
}

