/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.forex.response;

public class ForexUnit {
    private double open;
    private double high;
    private double low;
    private double close;
    private String date;

    private ForexUnit(Builder builder) {
        this.open = builder.open;
        this.high = builder.high;
        this.low = builder.low;
        this.close = builder.close;
        this.date = builder.date;
    }

    public String toString() {
        return "\nForexUnit{open=" + this.open + ", high=" + this.high + ", low=" + this.low + ", close=" + this.close + ", date=" + this.date + '}';
    }

    public double getOpen() {
        return this.open;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getClose() {
        return this.close;
    }

    public String getDate() {
        return this.date;
    }

    public static class Builder {
        double open;
        double high;
        double low;
        double close;
        String date;

        public Builder open(double open) {
            this.open = open;
            return this;
        }

        public Builder high(double high) {
            this.high = high;
            return this;
        }

        public Builder low(double low) {
            this.low = low;
            return this;
        }

        public Builder close(double close) {
            this.close = close;
            return this;
        }

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public ForexUnit build() {
            return new ForexUnit(this);
        }
    }
}

