/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.forex.response;

import com.crazzyghost.alphavantage.forex.response.ForexUnit;
import com.crazzyghost.alphavantage.forex.response.MetaData;
import com.crazzyghost.alphavantage.parser.DefaultParser;
import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ForexResponse {
    private MetaData metaData;
    private List<ForexUnit> forexUnits;
    private String errorMessage;

    private ForexResponse(MetaData metaData, List<ForexUnit> forexUnits) {
        this.metaData = metaData;
        this.forexUnits = forexUnits;
        this.errorMessage = null;
    }

    private ForexResponse(String errorMessage) {
        this.metaData = MetaData.empty();
        this.forexUnits = new ArrayList<ForexUnit>();
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public List<ForexUnit> getForexUnits() {
        return this.forexUnits;
    }

    public static ForexResponse of(Map<String, Object> stringObjectMap) {
        ForexParser parser = new ForexParser();
        return (ForexResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String toString() {
        return "ForexResponse{metaData=" + this.metaData + ", forexUnits=" + this.forexUnits.size() + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class ForexParser
    extends DefaultParser<ForexResponse> {
        @Override
        public ForexResponse onParseError(String error) {
            return new ForexResponse(error);
        }

        @Override
        public ForexResponse parse(Map<String, String> metaDataMap, Map<String, Map<String, String>> units) {
            String information = metaDataMap.get("1. Information");
            String fromSymbol = metaDataMap.get("2. From Symbol");
            String toSymbol = metaDataMap.get("3. To Symbol");
            String lastRefreshed = metaDataMap.getOrDefault("4. Last Refreshed", null);
            String interval = metaDataMap.getOrDefault("5. Interval", null);
            String outputSize = metaDataMap.getOrDefault("6. Output Size", null);
            String timeZone = metaDataMap.getOrDefault("7. Time Zone", null);
            if (metaDataMap.get("4. Last Refreshed") == null) {
                outputSize = metaDataMap.get("4. Output Size");
                lastRefreshed = metaDataMap.get("5. Last Refreshed");
                timeZone = metaDataMap.get("6. Time Zone");
            }
            MetaData metaData = new MetaData(information, fromSymbol, toSymbol, lastRefreshed, interval, outputSize, timeZone);
            ArrayList<ForexUnit> forexUnits = new ArrayList<ForexUnit>();
            for (Map.Entry<String, Map<String, String>> e : units.entrySet()) {
                ForexUnit.Builder forexUnit = new ForexUnit.Builder();
                Map<String, String> m = e.getValue();
                forexUnit.date(e.getKey());
                forexUnit.open(Double.parseDouble(m.get("1. open")));
                forexUnit.high(Double.parseDouble(m.get("2. high")));
                forexUnit.low(Double.parseDouble(m.get("3. low")));
                forexUnit.close(Double.parseDouble(m.get("4. close")));
                forexUnits.add(forexUnit.build());
            }
            return new ForexResponse(metaData, forexUnits);
        }
    }
}

