/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.forex.request;

import com.crazzyghost.alphavantage.parameters.DataType;

public abstract class ForexRequest {
    protected String from_symbol;
    protected String to_symbol;
    protected DataType dataType;

    protected ForexRequest(Builder<?> builder) {
        this.to_symbol = ((Builder)builder).toSymbol;
        this.from_symbol = ((Builder)builder).fromSymbol;
        this.dataType = ((Builder)builder).dataType;
    }

    public static abstract class Builder<T extends Builder<?>> {
        private String fromSymbol;
        private String toSymbol;
        private DataType dataType = DataType.JSON;

        public T fromSymbol(String fromSymbol) {
            this.fromSymbol = fromSymbol;
            return (T)this;
        }

        public T toSymbol(String fromSymbol) {
            this.toSymbol = fromSymbol;
            return (T)this;
        }

        public T dataType(DataType dataType) {
            this.dataType = dataType;
            return (T)this;
        }

        public abstract ForexRequest build();
    }
}

