/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.forex;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.forex.request.DailyRequest;
import com.crazzyghost.alphavantage.forex.request.ForexRequest;
import com.crazzyghost.alphavantage.forex.request.IntraDayRequest;
import com.crazzyghost.alphavantage.forex.request.MonthlyRequest;
import com.crazzyghost.alphavantage.forex.request.WeeklyRequest;
import com.crazzyghost.alphavantage.forex.response.ForexResponse;
import com.crazzyghost.alphavantage.parameters.DataType;
import com.crazzyghost.alphavantage.parameters.Interval;
import com.crazzyghost.alphavantage.parameters.OutputSize;
import com.crazzyghost.alphavantage.parser.Parser;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Forex
implements Fetcher {
    private final Config config;
    private ForexRequest.Builder<?> builder;
    private Fetcher.SuccessCallback<ForexResponse> successCallback;
    private Fetcher.FailureCallback failureCallback;

    public Forex(Config config) {
        this.config = config;
    }

    public WeeklyRequestProxy weekly() {
        return new WeeklyRequestProxy();
    }

    public DailyRequestProxy daily() {
        return new DailyRequestProxy();
    }

    public IntraDayRequestProxy intraday() {
        return new IntraDayRequestProxy();
    }

    public MonthlyRequestProxy monthly() {
        return new MonthlyRequestProxy();
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (Forex.this.failureCallback != null) {
                    Forex.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        ForexResponse forexResponse = ForexResponse.of(Parser.parseJSON(body.string()));
                        if (forexResponse.getErrorMessage() != null && Forex.this.failureCallback != null) {
                            Forex.this.failureCallback.onFailure(new AlphaVantageException(forexResponse.getErrorMessage()));
                        }
                        if (Forex.this.successCallback == null) return;
                        Forex.this.successCallback.onSuccess(forexResponse);
                        return;
                    }
                } else {
                    if (Forex.this.failureCallback == null) return;
                    Forex.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }
        });
    }

    private void fetchSync(Fetcher.SuccessCallback<ForexResponse> successCallback) throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = successCallback;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            ForexResponse forexResponse = ForexResponse.of(Parser.parseJSON(response.body().string()));
            this.successCallback.onSuccess(forexResponse);
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    public class MonthlyRequestProxy
    extends RequestProxy<MonthlyRequestProxy> {
        MonthlyRequestProxy() {
            this.builder = new MonthlyRequest.Builder();
        }
    }

    public class WeeklyRequestProxy
    extends RequestProxy<WeeklyRequestProxy> {
        WeeklyRequestProxy() {
            this.builder = new WeeklyRequest.Builder();
        }
    }

    public class IntraDayRequestProxy
    extends RequestProxy<IntraDayRequestProxy> {
        IntraDayRequestProxy() {
            this.builder = new IntraDayRequest.Builder();
        }

        public IntraDayRequestProxy outputSize(OutputSize size) {
            ((IntraDayRequest.Builder)this.builder).outputSize(size);
            return this;
        }

        public IntraDayRequestProxy interval(Interval interval) {
            ((IntraDayRequest.Builder)this.builder).interval(interval);
            return this;
        }
    }

    public class DailyRequestProxy
    extends RequestProxy<DailyRequestProxy> {
        DailyRequestProxy() {
            this.builder = new DailyRequest.Builder();
        }

        public DailyRequestProxy outputSize(OutputSize size) {
            ((DailyRequest.Builder)this.builder).outputSize(size);
            return this;
        }
    }

    public abstract class RequestProxy<T extends RequestProxy<?>> {
        protected ForexRequest.Builder<?> builder;
        protected ForexResponse syncResponse;

        private RequestProxy() {
            Forex.this.successCallback = null;
            Forex.this.failureCallback = null;
        }

        public T toSymbol(String toSymbol) {
            this.builder.toSymbol(toSymbol);
            return (T)this;
        }

        public T fromSymbol(String fromSymbol) {
            this.builder.fromSymbol(fromSymbol);
            return (T)this;
        }

        public T dataType(DataType type) {
            this.builder.dataType(type);
            return (T)this;
        }

        public T onSuccess(Fetcher.SuccessCallback<ForexResponse> callback) {
            Forex.this.successCallback = callback;
            return (T)this;
        }

        public T onFailure(Fetcher.FailureCallback callback) {
            Forex.this.failureCallback = callback;
            return (T)this;
        }

        public void fetch() {
            Forex.this.builder = this.builder;
            Forex.this.fetch();
        }

        public void setSyncResponse(ForexResponse response) {
            this.syncResponse = response;
        }

        public ForexResponse fetchSync() throws AlphaVantageException {
            Fetcher.SuccessCallback<ForexResponse> callback = e -> this.setSyncResponse((ForexResponse)e);
            Forex.this.builder = this.builder;
            Forex.this.fetchSync(callback);
            return this.syncResponse;
        }
    }
}

