/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.exchangerate;

import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.Map;

public class ExchangeRateResponse {
    private String fromCurrencyCode;
    private String fromCurrencyName;
    private String toCurrencyCode;
    private String toCurrencyName;
    private double exchangeRate;
    private String lastRefreshed;
    private String timeZone;
    private Double bidPrice;
    private Double askPrice;
    private final String errorMessage;

    private ExchangeRateResponse(String fromCurrencyCode, String fromCurrencyName, String toCurrencyCode, String toCurrencyName, Double exchangeRate, String lastRefreshed, String timeZone, Double bidPrice, Double askPrice) {
        this.fromCurrencyCode = fromCurrencyCode;
        this.fromCurrencyName = fromCurrencyName;
        this.toCurrencyCode = toCurrencyCode;
        this.toCurrencyName = toCurrencyName;
        this.exchangeRate = exchangeRate;
        this.lastRefreshed = lastRefreshed;
        this.timeZone = timeZone;
        this.bidPrice = bidPrice;
        this.askPrice = askPrice;
        this.errorMessage = null;
    }

    private ExchangeRateResponse(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static ExchangeRateResponse of(Map<String, Object> stringObjectMap) {
        ExchangeRateParser parser = new ExchangeRateParser();
        return (ExchangeRateResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Double getAskPrice() {
        return this.askPrice;
    }

    public Double getBidPrice() {
        return this.bidPrice;
    }

    public String getFromCurrencyCode() {
        return this.fromCurrencyCode;
    }

    public double getExchangeRate() {
        return this.exchangeRate;
    }

    public String getFromCurrencyName() {
        return this.fromCurrencyName;
    }

    public String getToCurrencyCode() {
        return this.toCurrencyCode;
    }

    public String getToCurrencyName() {
        return this.toCurrencyName;
    }

    public String getLastRefreshed() {
        return this.lastRefreshed;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "ExchangeRateResponse{fromCurrencyCode='" + this.fromCurrencyCode + '\'' + ", fromCurrencyName='" + this.fromCurrencyName + '\'' + ", toCurrencyCode='" + this.toCurrencyCode + '\'' + ", toCurrencyName='" + this.toCurrencyName + '\'' + ", exchangeRate=" + this.exchangeRate + ", lastRefreshed='" + this.lastRefreshed + '\'' + ", timeZone='" + this.timeZone + '\'' + ", bidPrice='" + this.bidPrice + '\'' + ", askPrice='" + this.askPrice + '\'' + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static class ExchangeRateParser
    extends Parser<ExchangeRateResponse> {
        @Override
        public ExchangeRateResponse parse(Map<String, Object> stringObjectMap) {
            Map data;
            ArrayList<String> keys2 = new ArrayList<String>(stringObjectMap.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                data = (Map)stringObjectMap.get(keys2.get(0));
            }
            catch (ClassCastException e) {
                return this.onParseError((String)stringObjectMap.get(keys2.get(0)));
            }
            Double bidPrice = ((String)data.get("8. Bid Price")).equals("-") ? null : Double.valueOf(Double.parseDouble((String)data.get("8. Bid Price")));
            Double askPrice = ((String)data.get("9. Ask Price")).equals("-") ? null : Double.valueOf(Double.parseDouble((String)data.get("9. Ask Price")));
            return new ExchangeRateResponse((String)data.get("1. From_Currency Code"), (String)data.get("2. From_Currency Name"), (String)data.get("3. To_Currency Code"), (String)data.get("4. To_Currency Name"), Double.parseDouble((String)data.get("5. Exchange Rate")), (String)data.get("6. Last Refreshed"), (String)data.get("7. Time Zone"), bidPrice, askPrice);
        }

        @Override
        public ExchangeRateResponse onParseError(String error) {
            return new ExchangeRateResponse(error);
        }
    }
}

