/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.cryptocurrency.response;

import com.crazzyghost.alphavantage.parser.Parser;
import java.util.ArrayList;
import java.util.Map;

public class RatingResponse {
    private String symbol;
    private String name;
    private String fcasRating;
    private String fcasScore;
    private String developerScore;
    private String marketMaturityScore;
    private String utilityScore;
    private String lastRefreshed;
    private String timeZone;
    private String errorMessage;

    public RatingResponse(String symbol, String name, String fcasRating, String fcasScore, String developerScore, String marketMaturityScore, String utilityScore, String lastRefreshed, String timeZone) {
        this.symbol = symbol;
        this.name = name;
        this.fcasRating = fcasRating;
        this.fcasScore = fcasScore;
        this.developerScore = developerScore;
        this.marketMaturityScore = marketMaturityScore;
        this.utilityScore = utilityScore;
        this.lastRefreshed = lastRefreshed;
        this.timeZone = timeZone;
    }

    private RatingResponse(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static RatingResponse of(Map<String, Object> stringObjectMap) {
        RatingParser parser = new RatingParser();
        return (RatingResponse)((Parser)parser).parse(stringObjectMap);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getName() {
        return this.name;
    }

    public String getFcasRating() {
        return this.fcasRating;
    }

    public String getFcasScore() {
        return this.fcasScore;
    }

    public String getDeveloperScore() {
        return this.developerScore;
    }

    public String getMarketMaturityScore() {
        return this.marketMaturityScore;
    }

    public String getUtilityScore() {
        return this.utilityScore;
    }

    public String getLastRefreshed() {
        return this.lastRefreshed;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return "RatingResponse {developerScore=" + this.developerScore + ", fcasRating=" + this.fcasRating + ", fcasScore=" + this.fcasScore + ", lastRefreshed=" + this.lastRefreshed + ", marketMaturityScore=" + this.marketMaturityScore + ", name=" + this.name + ", symbol=" + this.symbol + ", timeZone=" + this.timeZone + ", utilityScore=" + this.utilityScore + ", errorMessage" + this.errorMessage + "}";
    }

    private static class RatingParser
    extends Parser<RatingResponse> {
        private RatingParser() {
        }

        @Override
        public RatingResponse parse(Map<String, Object> stringObjectMap) {
            ArrayList<String> keys2 = new ArrayList<String>(stringObjectMap.keySet());
            if (keys2.isEmpty()) {
                return this.onParseError("Empty JSON returned by the API, the symbol might not be supported.");
            }
            try {
                Map md = (Map)stringObjectMap.get(keys2.get(0));
                String symbol = (String)md.get("1. symbol");
                String name = (String)md.get("2. name");
                String fcasRating = (String)md.get("3. fcas rating");
                String fcasScore = (String)md.get("4. fcas score");
                String developerScore = (String)md.get("5. developer score");
                String marketMaturityScore = (String)md.get("6. market maturity score");
                String utilityScore = (String)md.get("7. utility score");
                String lastRefreshed = (String)md.get("8. last refreshed");
                String timeZone = (String)md.get("9. timezone");
                return new RatingResponse(symbol, name, fcasRating, fcasScore, developerScore, marketMaturityScore, utilityScore, lastRefreshed, timeZone);
            }
            catch (ClassCastException e) {
                return this.onParseError(stringObjectMap.get(keys2.get(0)).toString());
            }
        }

        @Override
        public RatingResponse onParseError(String error) {
            return new RatingResponse(error);
        }
    }
}

