/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.cryptocurrency.response;

public class CryptoUnit {
    private final double open;
    private final double close;
    private final double high;
    private final double low;
    private final double openUSD;
    private final double closeUSD;
    private final double highUSD;
    private final double lowUSD;
    private final double volume;
    private final double marketCap;
    private final String date;

    public CryptoUnit(Builder builder) {
        this.open = builder.open;
        this.close = builder.close;
        this.high = builder.high;
        this.low = builder.low;
        this.openUSD = builder.openUSD;
        this.closeUSD = builder.closeUSD;
        this.highUSD = builder.highUSD;
        this.lowUSD = builder.lowUSD;
        this.volume = builder.volume;
        this.marketCap = builder.marketCap;
        this.date = builder.date;
    }

    public double getOpen() {
        return this.open;
    }

    public double getClose() {
        return this.close;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    public double getOpenUSD() {
        return this.openUSD;
    }

    public double getCloseUSD() {
        return this.closeUSD;
    }

    public double getHighUSD() {
        return this.highUSD;
    }

    public double getLowUSD() {
        return this.lowUSD;
    }

    public double getVolume() {
        return this.volume;
    }

    public double getMarketCap() {
        return this.marketCap;
    }

    public String getDate() {
        return this.date;
    }

    public String toString() {
        return "\nCryptoUnit {date=" + this.date + ", close=" + this.close + ", closeUSD=" + this.closeUSD + ", high=" + this.high + ", highUSD=" + this.highUSD + ", low=" + this.low + ", lowUSD=" + this.lowUSD + ", marketCap=" + this.marketCap + ", open=" + this.open + ", openUSD=" + this.openUSD + ", volume=" + this.volume + "}";
    }

    public static class Builder {
        double open;
        double high;
        double low;
        double close;
        double openUSD;
        double closeUSD;
        double highUSD;
        double lowUSD;
        double volume;
        double marketCap;
        String date;

        public Builder open(double open) {
            this.open = open;
            return this;
        }

        public Builder high(double high) {
            this.high = high;
            return this;
        }

        public Builder low(double low) {
            this.low = low;
            return this;
        }

        public Builder close(double close) {
            this.close = close;
            return this;
        }

        public Builder openUSD(double openUSD) {
            this.openUSD = openUSD;
            return this;
        }

        public Builder highUSD(double highUSD) {
            this.highUSD = highUSD;
            return this;
        }

        public Builder lowUSD(double lowUSD) {
            this.lowUSD = lowUSD;
            return this;
        }

        public Builder closeUSD(double closeUSD) {
            this.closeUSD = closeUSD;
            return this;
        }

        public Builder marketCap(double marketCap) {
            this.marketCap = marketCap;
            return this;
        }

        public Builder volume(double volume) {
            this.volume = volume;
            return this;
        }

        public Builder date(String date) {
            this.date = date;
            return this;
        }

        public CryptoUnit build() {
            return new CryptoUnit(this);
        }
    }
}

