/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage.cryptocurrency;

import com.crazzyghost.alphavantage.AlphaVantageException;
import com.crazzyghost.alphavantage.Config;
import com.crazzyghost.alphavantage.Fetcher;
import com.crazzyghost.alphavantage.UrlExtractor;
import com.crazzyghost.alphavantage.cryptocurrency.request.CryptoRequest;
import com.crazzyghost.alphavantage.cryptocurrency.request.DigitalCurrencyRequest;
import com.crazzyghost.alphavantage.cryptocurrency.request.RatingRequest;
import com.crazzyghost.alphavantage.cryptocurrency.response.CryptoResponse;
import com.crazzyghost.alphavantage.cryptocurrency.response.RatingResponse;
import com.crazzyghost.alphavantage.parameters.Function;
import com.crazzyghost.alphavantage.parser.Parser;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class Crypto
implements Fetcher {
    private final Config config;
    private CryptoRequest.Builder<?> builder;
    private Fetcher.SuccessCallback<?> successCallback;
    private Fetcher.FailureCallback failureCallback;

    public Crypto(Config config) {
        this.config = config;
    }

    public DailyRequestProxy daily() {
        return new DailyRequestProxy();
    }

    public WeeklyRequestProxy weekly() {
        return new WeeklyRequestProxy();
    }

    public MonthlyRequestProxy monthly() {
        return new MonthlyRequestProxy();
    }

    public RatingRequestProxy rating() {
        return new RatingRequestProxy();
    }

    @Override
    public void fetch() {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.config.getOkHttpClient().newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (Crypto.this.failureCallback != null) {
                    Crypto.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        Crypto.this.parseCryptoResponse(Parser.parseJSON(body.string()));
                    }
                } else if (Crypto.this.failureCallback != null) {
                    Crypto.this.failureCallback.onFailure(new AlphaVantageException());
                }
            }
        });
    }

    private void fetchSync(Fetcher.SuccessCallback<?> successCallback) throws AlphaVantageException {
        Config.checkNotNullOrKeyEmpty(this.config);
        this.successCallback = successCallback;
        this.failureCallback = null;
        OkHttpClient client = this.config.getOkHttpClient();
        try (Response response = client.newCall(UrlExtractor.extract(this.builder.build(), this.config.getKey())).execute();){
            this.parseCryptoResponse(Parser.parseJSON(response.body().string()));
        }
        catch (IOException e) {
            throw new AlphaVantageException(e.getMessage());
        }
    }

    private void parseCryptoResponse(Map<String, Object> data) {
        switch (this.builder.function) {
            case CRYPTO_RATING: {
                this.parseRatingResponse(data);
                break;
            }
            case DIGITAL_CURRENCY_DAILY: 
            case DIGITAL_CURRENCY_MONTHLY: 
            case DIGITAL_CURRENCY_WEEKLY: {
                this.parseDigitalCurrencyResponse(data);
            }
        }
    }

    private void parseDigitalCurrencyResponse(Map<String, Object> data) {
        CryptoResponse response = CryptoResponse.of(data, ((DigitalCurrencyRequest.Builder)this.builder).getMarket());
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    private void parseRatingResponse(Map<String, Object> data) {
        RatingResponse response = RatingResponse.of(data);
        if (response.getErrorMessage() != null && this.failureCallback != null) {
            this.failureCallback.onFailure(new AlphaVantageException(response.getErrorMessage()));
        }
        if (this.successCallback != null) {
            this.successCallback.onSuccess(response);
        }
    }

    public class RatingRequestProxy
    extends RequestProxy<RatingRequestProxy, RatingResponse> {
        public RatingRequestProxy() {
            this.builder = new RatingRequest.Builder();
        }
    }

    public class MonthlyRequestProxy
    extends RequestProxy<MonthlyRequestProxy, CryptoResponse> {
        public MonthlyRequestProxy() {
            this.builder = new DigitalCurrencyRequest.Builder();
            this.builder = this.builder.function(Function.DIGITAL_CURRENCY_MONTHLY);
        }

        public MonthlyRequestProxy market(String market) {
            ((DigitalCurrencyRequest.Builder)this.builder).market(market);
            return this;
        }
    }

    public class WeeklyRequestProxy
    extends RequestProxy<WeeklyRequestProxy, CryptoResponse> {
        public WeeklyRequestProxy() {
            this.builder = new DigitalCurrencyRequest.Builder();
            this.builder = this.builder.function(Function.DIGITAL_CURRENCY_WEEKLY);
        }

        public WeeklyRequestProxy market(String market) {
            ((DigitalCurrencyRequest.Builder)this.builder).market(market);
            return this;
        }
    }

    public class DailyRequestProxy
    extends RequestProxy<DailyRequestProxy, CryptoResponse> {
        public DailyRequestProxy() {
            this.builder = new DigitalCurrencyRequest.Builder();
            this.builder = this.builder.function(Function.DIGITAL_CURRENCY_DAILY);
        }

        public DailyRequestProxy market(String market) {
            ((DigitalCurrencyRequest.Builder)this.builder).market(market);
            return this;
        }
    }

    public abstract class RequestProxy<T extends RequestProxy<?, U>, U> {
        protected CryptoRequest.Builder<?> builder;
        protected U syncResponse;

        private RequestProxy() {
        }

        public T forSymbol(String symbol) {
            this.builder.symbol(symbol);
            return (T)this;
        }

        public T onSuccess(Fetcher.SuccessCallback<?> callback) {
            Crypto.this.successCallback = callback;
            return (T)this;
        }

        public T onFailure(Fetcher.FailureCallback callback) {
            Crypto.this.failureCallback = callback;
            return (T)this;
        }

        public void fetch() {
            Crypto.this.builder = this.builder;
            Crypto.this.fetch();
        }

        public void setSyncResponse(U response) {
            this.syncResponse = response;
        }

        public U fetchSync() throws AlphaVantageException {
            Fetcher.SuccessCallback<Object> callback = this::setSyncResponse;
            Crypto.this.builder = this.builder;
            Crypto.this.fetchSync(callback);
            return this.syncResponse;
        }
    }
}

