/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage;

import com.crazzyghost.alphavantage.AlphaVantageException;
import java.lang.reflect.Field;
import okhttp3.Request;

public class UrlExtractor {
    private UrlExtractor() {
    }

    public static String extract(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> cls = object.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    if (field.isSynthetic() || field.get(object) == null) continue;
                    stringBuilder.append(field.getName().toLowerCase()).append("=");
                    String value = field.get(object).toString();
                    stringBuilder.append(value).append("&");
                }
                catch (IllegalAccessException e) {
                    throw new AlphaVantageException(e.getLocalizedMessage());
                }
            }
        }
        return stringBuilder.append("apikey=").toString();
    }

    public static Request extract(Object request, String apiKey) {
        return new Request.Builder().url("https://www.alphavantage.co/query?" + UrlExtractor.extract(request) + apiKey).build();
    }
}

