/*
 * Decompiled with CFR 0.152.
 */
package com.crazzyghost.alphavantage;

import com.crazzyghost.alphavantage.AlphaVantageException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class Config {
    public static final String BASE_URL = "https://www.alphavantage.co/query?";
    private final String key;
    private final int timeOut;
    private final OkHttpClient httpClient;

    private Config(Builder builder) {
        this.key = builder.key;
        this.timeOut = builder.timeOut;
        this.httpClient = builder.httpClient == null ? this.defaultClient(builder.timeOut) : builder.httpClient;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public String getKey() {
        return this.key;
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OkHttpClient defaultClient(int timeOut) {
        return new OkHttpClient.Builder().connectTimeout((long)timeOut, TimeUnit.SECONDS).build();
    }

    public static void checkNotNullOrKeyEmpty(Config config) {
        if (config == null) {
            throw new AlphaVantageException("Config not set");
        }
        if (config.getKey() == null) {
            throw new AlphaVantageException("API Key not set");
        }
    }

    public static class Builder {
        private String key;
        private int timeOut;
        private OkHttpClient httpClient;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder timeOut(int timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

